<?php
/**
* Template for team section
* 
* @since WP Deep Blue 1.0
*/
$page_id = wp_deep_blue_get( 'team-page' );

if( $page_id ):
    $query = new WP_Query(array(
        'page_id' => $page_id
    ));
?>

<!-- TEAM SECTION-->
<svg class="margin-btm-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1366.5 34.5">
    <polyline class="cls-1" fill="#F3F7FF" points="1366 0 1366 34 0 34" />
</svg>

<div class="wp-deep-blue-section-gap wp-deep-blue-team-section wp-deep-blue-light-primary-bg ">

    <?php 
        if( $query->have_posts() ): 
            while( $query->have_posts() ):
                $query->the_post();
                $sub_text = wp_deep_blue_get( 'team-sub-text' );
    ?>
                <div class="wp-deep-blue-title-n-short-content text-center">
                    <span class="wp-deep-blue-sub-title-tag"><?php echo esc_html( $sub_text ); ?></span>
                    <h2><?php the_title(); ?></h2>
                    <?php the_excerpt(); ?>
                </div>
    <?php 
            endwhile; 
        endif; 
    ?>

    <?php
        $pages = wp_deep_blue_get( 'team-pages' );

        if( $pages ):
            $team_col = absint( wp_deep_blue_get( 'team-col' ) );
            $args = apply_filters( 'wp_deep_blue_team_pages_args', array(
                'post_type'      => 'page',
                'post__in'       => json_decode( $pages ),
                'orderby'        => 'post__in',
                'posts_per_page' => $team_col
            ));
            $query = new WP_Query( $args );
    ?>
            <div class="container">
                <div class="row">
                    <?php while( $query->have_posts() ): 
                        $query->the_post();
                        $thumbnail = get_the_post_thumbnail_url( null, 'full' );
                        $alt = wp_deep_blue_get_the_post_thumbnail_text();
                        $title = wp_deep_blue_get_title_with_designation();
                    ?>
                            <div class="col-md-<?php echo esc_attr( 12 / $team_col ); ?> wp-deep-blue-content-wrapper">
                                <div class="wp-deep-blue-staff">
                                    <div class="wp-deep-blue-staff-img" style="background-image: url('<?php echo esc_url( $thumbnail ); ?>')">
                                    </div>

                                    <div class="wp-deep-blue-content">
                                        <h3>
                                            <a href="<?php the_permalink(); ?>">
                                                <?php echo esc_html( $title[ 0 ] ); ?>
                                            </a>
                                        </h3>
                                        <p><?php echo esc_html( $title[ 1 ] ); ?></p>
                                    </div>
                                </div>
                            </div>
                    <?php endwhile; wp_reset_postdata(); ?>
                </div>
                <?php
                    $btn_txt = wp_deep_blue_get( 'team-btn-text' );
                    $team_archive_id = wp_deep_blue_get( 'team-archive-page' );
                    if( $team_archive_id > 0 ):
                ?>
                        <div class="wp-deep-blue-team-btn">
                            <a href="<?php echo esc_attr( get_permalink( $team_archive_id ) ) ?>" class="wp-deep-blue-btn-primary"> 
                                 <?php echo esc_html( $btn_txt ); ?> <i class="bi bi-arrow-right"></i>
                            </a>    
                        </div>
                    <?php endif; ?> 
            </div>
    <?php wp_reset_postdata(); endif; ?>
</div>
<svg class="margin-top-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1366.5 34.5">
    <polyline class="cls-1" fill="#F3F7FF" points="0.5 34.5 0.5 0.5 1366.5 0.5" />
</svg>
<?php endif; ?>