<?php
/**
* Template for about section
* @since WP Deep Blue 1.0
*/
$page_id = wp_deep_blue_get( 'service-page' );

if( $page_id ):
    $query = new WP_Query(array(
        'page_id' => $page_id
    ));
    if( $query->have_posts() ):
?>

<!-- SERVICES -->
<div class="container wp-deep-blue-our-services-section wp-deep-blue-section-gap-top">
    <?php
        $permalink = '#';
        while( $query->have_posts() ):
            $query->the_post();
            $permalink = get_the_permalink();
            $sub_text = wp_deep_blue_get( 'service-sub-text' );
        ?>
        <div class="wp-deep-blue-title-n-short-content text-center">
            <span class="wp-deep-blue-sub-title-tag"><?php echo esc_html( $sub_text ); ?></span>
            <h2><?php the_title(); ?></h2>
            <?php the_excerpt(); ?>
        </div>
    <?php endwhile; ?>

    <?php
        $pages = wp_deep_blue_get( 'service-pages' );
        $args = apply_filters( 'wp_deep_blue_services_pages_args', array(
            'post_type' => 'page',
            'post__in'  => json_decode( $pages )
        ));
        $query = new WP_Query( $args );
        if( $query->have_posts() ):
    ?>
            <div class="row">
                <?php while( $query->have_posts() ): $query->the_post(); ?>
                    <div class="col-md-3">
                        <div class="row">
                            <div class="wp-deep-blue-service">
                                <?php 
                                    $thumbnail = get_the_post_thumbnail_url( null, 'medium' );
                                    $alt = wp_deep_blue_get_the_post_thumbnail_text();
                                ?>

                                <?php if( $thumbnail ): ?>
                                    <div>
                                        <img src="<?php echo esc_url( $thumbnail ); ?>" alt="<?php echo esc_attr( $alt ); ?>">
                                    </div>
                                <?php endif; ?>
                                <h2>
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h2>
                                <?php the_excerpt(); ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
            <?php
                $btn_text = wp_deep_blue_get( 'service-btn-text' );
            ?>
            <div class="text-center mt-5 pb-3">
                <a href="<?php echo esc_url( $permalink ); ?>" class="wp-deep-blue-btn-secondary"> <?php echo esc_html( $btn_text ); ?> <i class="bi bi-arrow-right"></i></a>
            </div>
    <?php wp_reset_postdata(); endif; ?>
</div>
<?php endif;
endif;