<?php
/**
*  Template for brand section
* @since WP Deep Blue 1.0
*/
$page_id = wp_deep_blue_get( 'brand-content-page' );

if( $page_id ):
    $query = new WP_Query(array(
        'page_id' => $page_id
    ));
?>
    <!-- CLIENT LOGO SLIDER SECTION -->
    <div class="container wp-deep-blue-client-logo-section">
        <?php
            if( $query->have_posts() ):
                while( $query->have_posts() ):
                    $query->the_post();
                    $title = wp_deep_blue_get_title_with_designation();
                ?>
                    <div class="title">
                        <?php echo esc_html( $title[0] ); ?>
                        <span><?php echo esc_html( $title[1] ); ?></span>
                    </div>
                <?php endwhile; ?>
        <?php endif; ?>

        <?php
            $pages = wp_deep_blue_get( 'brand-pages' );

            if( $pages ):
                $args = apply_filters( 'wp_deep_blue_brand_pages_args', array(
                    'post_type' => 'page',
                    'post__in'  => json_decode( $pages )
                ));
                $query = new WP_Query( $args );
        ?>
                <div class="wp-deep-blue-client-logo-slider">
                    <ul id="clients-logo">
                        <?php while( $query->have_posts() ): 
                            $query->the_post();
                            $thumbnail = get_the_post_thumbnail_url( null, 'full' );
                            $alt = wp_deep_blue_get_the_post_thumbnail_text();
                            if( $thumbnail ):
                        ?>
                            <li>
                                <img src="<?php echo esc_url( $thumbnail ); ?>" alt="<?php echo esc_attr( $alt ); ?>" />
                            </li>
                        <?php endif; endwhile; ?>  
                    </ul>
                </div>
        <?php wp_reset_postdata(); endif; ?>
    </div>
<?php endif; ?>