<?php
/**
*  Template for acguevement section
* @since WP Deep Blue 1.0
*/
?>
<!-- BLOGS POST -->
<svg class="margin-btm-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1366.5 34.5">
    <polyline class="cls-1" fill="#F3F7FF" points="1366 0 1366 34 0 34" />
</svg>
<div class="wp-deep-blue-section-gap wp-deep-blue-blog-section">
    <div class="container ">
        <?php
            $page_id = wp_deep_blue_get( 'blog-page' );

            if( $page_id ):
                $query = new WP_Query(array(
                    'page_id' => $page_id
                ));
                $sub_text = wp_deep_blue_get( 'blog-sub-text' );
                while( $query->have_posts() ): $query->the_post();
        ?>
                <div class="wp-deep-blue-title-n-short-content text-center">
                    <span class="wp-deep-blue-sub-title-tag"><?php echo esc_html( $sub_text ); ?></span>
                    <h2><?php the_title(); ?></h2>
                    <?php the_excerpt(); ?>
                </div>
        <?php endwhile; endif; ?>

        <?php
            $col = wp_deep_blue_get( 'blog-col' );
            $query = new WP_Query(array(
                'posts_per_page' => $col,
                'ignore_sticky_posts' => true
            ));

            if( $query->have_posts() ):
        ?>
            <div class="row">
                <?php while( $query->have_posts() ): $query->the_post(); ?>
                    <?php
                        $thumbnail = get_the_post_thumbnail_url( null, 'full' );
                        $alt = wp_deep_blue_get_the_post_thumbnail_text();
                    ?>
                    <div class="col-md-<?php echo esc_attr( 12 / $col ); ?>">
                        <div class="wp-deep-blue-blog-card">
                                <?php if( $thumbnail ): ?>
                                    <div class="wp-deep-blue-img" style="background-image: url('<?php echo esc_url( $thumbnail ); ?>');">
                                    </div>
                                <?php endif; ?>

                            <div class="wp-deep-blue-content">
                                <?php wp_deep_blue_author_image(); ?>
                                    
                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

                                <div class="wp-deep-blue-links">
                                    <?php wp_deep_blue_comments_popup_link(); ?>
                                    <a href="<?php echo esc_url( wp_deep_blue_get_day_link() ); ?>"><span class="bi bi-calendar3"></span><span><?php echo get_the_date( 'M j Y' ); ?></span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php endif; wp_reset_postdata(); ?>
    </div>
</div>
<svg class="margin-top-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1366.5 34.5">
    <polyline class="cls-1" fill="#F3F7FF" points="0.5 34.5 0.5 0.5 1366.5 0.5" />
</svg>
