<?php
/**
*  Template for acguevement section
* @since WP Deep Blue 1.0
*/
$page_id = wp_deep_blue_get( 'achievement-page' );

if( $page_id ):
    $query = new WP_Query(array(
        'page_id' => $page_id
    ));
    $sub_text = wp_deep_blue_get( 'achievement-sub-text' );
?>
<!-- ACHIEVEMENT SECTION -->
<div class="container wp-deep-blue-section-gap-top  wp-deep-blue-achievements">

    <div class="row">
        <div class="col-md-7">
            <?php
                if( $query->have_posts() ):
                    while( $query->have_posts() ):
                        $query->the_post();
                        $thumbnail = get_the_post_thumbnail_url( null, 'full' );
                        $alt = wp_deep_blue_get_the_post_thumbnail_text();
                    ?>
                        <div class="wp-deep-blue-title-n-short-content mb-5">
                            <span class="wp-deep-blue-sub-title-tag"><?php echo esc_html( $sub_text ); ?></span>
                            <h2><?php the_title(); ?></h2>
                        </div>
                    <?php endwhile; ?>
            <?php endif; ?>

            <?php
                $pages = wp_deep_blue_get( 'achievement-pages' );

                if( $pages ):
                    $args = apply_filters( 'wp_deep_blue_achivement_pages_args', array(
                        'post_type' => 'page',
                        'post__in'  => json_decode( $pages )
                    ));
                    $query = new WP_Query( $args );
            ?>
                <div class="row">
                    <?php 
                        while( $query->have_posts() ): 
                            $query->the_post();
                    ?>
                            <div class="col-md-4">
                                <div class="wp-deep-blue-achievement-box">
                                    <h3><?php the_excerpt(); ?></h3>
                                    <div class="wp-deep-blue-content">
                                        <p><?php the_title(); ?></p>
                                    </div>
                                </div>
                            </div>
                    <?php endwhile; ?>

                </div>
            <?php wp_reset_postdata(); endif; ?>
        </div>
        <div class="col-md-5">
            <?php if( isset( $thumbnail ) && $thumbnail ): ?>
                <img src="<?php echo esc_url( $thumbnail ); ?>" alt="<?php echo esc_attr( $alt ); ?>" />
            <?php endif; ?>
        </div>
    </div>
</div>
<?php endif; ?>