<?php
/**
*  Template for about section
* @since WP Deep Blue 1.0
*/
$page_id = wp_deep_blue_get( 'about-page' );

if( $page_id ):
    $query = new WP_Query(array(
        'page_id' => $page_id
    ));
    if( $query->have_posts() ):
        while( $query->have_posts() ):
            $query->the_post();
            $btn_text = wp_deep_blue_get( 'about-btn-text' );
            $sub_text = wp_deep_blue_get( 'about-sub-text' );
            $thumbnail = get_the_post_thumbnail_url( null, 'full' );
            $alt = wp_deep_blue_get_the_post_thumbnail_text();
        ?>
            <!-- ABOUT US SECTION -->
            <div class="container wp-deep-blue-section-gap wp-deep-blue-about-us-section">
                <div class="row">
                    <div class="col-md-6">
                        <div class="wp-deep-blue-img-wrapper">
                            <div class="wp-deep-blue-floating-img wp-deep-blue-circle-xl">
                            </div>
                            <div class="wp-deep-blue-bracket-symbol">
                                <span></span>
                                <span></span>
                            </div>
                            <span class="wp-deep-blue-circle-xl"></span>
                            <?php if( $thumbnail ): ?>
                                <img class="img-fluid" src="<?php echo esc_url( $thumbnail ); ?>" alt="<?php echo esc_attr( $alt ); ?>">
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-md-6 wp-deep-blue-content-wrapper">
                        <div class="wp-deep-blue-content">
                            <div class="wp-deep-blue-title-n-short-content">
                                <span class="wp-deep-blue-sub-title-tag"><?php echo esc_html( $sub_text ); ?></span>
                                <h2><?php the_title(); ?></h2>
                                <?php the_excerpt(); ?>
                            </div>
                            <div class="wp-deep-blue-btns">
                                <a href="<?php the_permalink(); ?>" class="wp-deep-blue-btn-primary">
                                    <?php echo esc_html( $btn_text ); ?> 
                                    <i class="bi bi-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endwhile;
    endif;
    wp_reset_postdata();
endif;
