<?php
/**
 * The default template for displaying content
 *
 * Used for both index.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Deep Blue
 * @since WP Deep Blue 1.0
 */

$cls = wp_deep_blue_has_sidebar() ? 'col-md-6 col-xxl-4' : 'col-lg-4 col-xxl-3';
?>
<div class="<?php echo esc_attr( $cls ); ?>">
	<div class="wp-deep-blue-post">
		<article <?php post_class(); ?> <?php echo wp_deep_blue_schema( 'article' ); ?> id="post-<?php the_ID(); ?>">
			<figure class="featured-media">
				<?php if( has_post_thumbnail() ): ?>
					<div class="featured-media-image" 
					style="background-image: url( '<?php echo esc_url( get_the_post_thumbnail_url() ); ?>')"></div>
				<?php endif; ?>
				<?php wp_deep_blue_category(); ?>
			</figure>

			<div class="post-content-inner">

				<header class="entry-header">
					<h2 class="post-title">
						<a href="<?php the_permalink(); ?>">
							<?php the_title(); ?>
						</a>
					</h2>
				</header>

				<div class="entry-meta wp-deep-blue-entry-meta">
					<?php wp_deep_blue_author_image(); ?>
					<div class="author-info">
						<?php
							wp_deep_blue_the_date();			
							wp_deep_blue_posted_by();
						?>
					</div>
				</div>

			</div>

		</article>
	</div>
</div>