<?php
/**
 * Enqueue scripts and styles
 * @since WP Deep Blue 1.0
 */
if( !function_exists( 'wp_deep_blue_enqueue_scripts' ) ){

	function wp_deep_blue_enqueue_scripts( $scripts, $base, $dir = true ){
		
		$type = WP_DEBUG ? '' : 'min.'; //min.

		foreach( $scripts as $h => $script ){
			$v = $script[ 'version' ];
			
			$style_path =  $dir ? "{$base}/{$h}/{$h}.{$type}" : "{$base}/{$h}.{$type}";
			$style_path = get_theme_file_uri( $style_path . "css" );

			if( !isset( $script[ 'no-style' ] ) ){
				wp_enqueue_style( $h, $style_path, array(), $v );
			}

			if( !isset( $script[ 'no-script' ] ) ){
				if( isset( $script[ 'file' ] ) ){
					$js_path = $script[ 'file' ];
				}else{
					$js_path =  $dir ? "{$base}/{$h}/{$h}.{$type}" : "{$base}/{$h}.{$type}";
					$js_path = get_theme_file_uri( $js_path . "js" );
				}
				wp_enqueue_script( $h, $js_path, array( 'jquery' ), $v );
			}
		}
	}
}
/**
 * Add scripts and styles
 * @since Base Theme 1.0
 */
function wp_deep_blue_scripts(){

	$theme_version = wp_get_theme()->get( 'Version' );

	wp_enqueue_style( 'wp-deep-blue-style', get_stylesheet_uri(), array(), $theme_version );

	$scripts = array( 
		'bootstrap' => array(
			'version' => '5.0.0'
		),
		'bootstrap-icons' => array(
			'version' => '1.0.0',
			'no-script' => true
		),
		'select2' => array(
			'version' => '1.0.0'
		),
		'slick' => array(
			'version' => '1.8.0'
		),
		'zoom' => array(
			'version' => '1.7.0',
			'no-style' => true
		)
	);

	wp_deep_blue_enqueue_scripts( $scripts, "assets/build/vendors" );

	$scripts = array(
 		'fst-mmenu' => array(
 			'version' => '1.0'
 		),
 		'fst-popup-search' => array(
 			'version' => '1.0'
 		),
 		'fst-show-nav-on-screen' => array(
 			'version' => '1.0',
 			'no-style' => true
 		),
 		'fst-scrolltop' => array(
 			'version' => '1.0'
 		),
 		'fst-custom-input-number' => array(
 			'version' => '1.0'
 		),
 		'fst-cookie-policy' => array(
 			'version' => '1.0'
 		)
	);

	wp_deep_blue_enqueue_scripts( $scripts, "assets/build/plugins" );
	
	$scripts = array(
		'blocks' => array(
			'version' => '1.0',
			'no-script' => true
		),
		'base' => array(
			'version' => '1.0',
			'no-script' => true
		),
		'theme' => array(
			'version' => '1.0',
			'no-script' => true
		)
	);

	wp_deep_blue_enqueue_scripts( $scripts, "assets/build/css", false );

	$scripts = array(
		'base' => array(
			'version' => '1.0',
			'no-style' => true
		),
		'theme' => array(
			'version' => '1.0',
			'no-style' => true
		)
	);

	wp_deep_blue_enqueue_scripts( $scripts, "assets/build/js", false );
	wp_localize_script( 'theme', 'WPDEEPBLUE', array(
		'search_label' => esc_html__( 'What are you looking for?', 'wp-deep-blue' ),
		'home_url'     => esc_url( home_url( '/' ) ),
		'enable_scroll_top' => wp_deep_blue_get( 'enable-scroll-to-top' ),
		'enable_search' => wp_deep_blue_get( 'enable-search' ),
		'cookie_consent' => wp_deep_blue_get( 'enable-cookie-consent' ),
		'cookie_policy_text' => esc_html__( 'We use third-party cookies in order to personalize your site experience.', 'wp-deep-blue' ),
		'cookie_policy_accept_text' => esc_html__( 'Allow', 'wp-deep-blue' ),
		'cookie_policy_decline_text' => esc_html__( 'Decline', 'wp-deep-blue' )
	));
	
	#fonts
	wp_enqueue_style( 'wp-deep-blue-fonts', wp_deep_blue_generate_font_url() );
	# enqueue comment-reply.js in single page only
	if( ( is_single() || is_page() ) && comments_open() && get_option( 'thread_comments' ) ){
		wp_enqueue_script( 'comment-reply' );
	}

	# load rtl.css if site is RTL
	if( is_rtl() ){	
		wp_enqueue_style( 'wp-deep-blue-rtl', get_theme_file_uri( 'rtl.css' ), array(), $theme_version );
	}
}
add_action( 'wp_enqueue_scripts', 'wp_deep_blue_scripts' ); 

/**
 * Add block assets
 * @since Base Theme 1.0
 */
function wp_deep_blue_editor_assets(){
	$theme_version = wp_get_theme()->get( 'Version' );
	$type = WP_DEBUG ? '' : 'min.'; //min.
	wp_enqueue_style( 'wp-deep-blue-editor-style', get_theme_file_uri( "assets/build/css/block-editor-styles.{$type}css" ), array(), $theme_version );
}
add_action( 'enqueue_block_editor_assets', 'wp_deep_blue_editor_assets' );

/**
 * Add css for backend
 * @since Base Theme 1.0
 */
function wp_deep_blue_admin_scripts(){
	$theme_version = wp_get_theme()->get( 'Version' );
	$type = WP_DEBUG ? '' : 'min.'; //min.
	wp_enqueue_style( 'wp-deep-blue-admin-style', get_theme_file_uri( "assets/build/css/admin.{$type}css" ), array(), $theme_version );
}
add_action( 'admin_enqueue_scripts', 'wp_deep_blue_admin_scripts' );