<?php
/**
 * front page theme options
 * @since WP Deep Blue 1.0
 */
if( !class_exists( 'WP_Deep_Blue_Frontpage_Customizer' ) ){
	class WP_Deep_Blue_Frontpage_Customizer extends WP_Deep_Blue_Customizer{

		public $fields = array();

		public function __construct( $panel ){

			$this->fields = array(
				array(
					'id'    => 'general-frontpage-section',
					'title' => esc_html__( 'General', 'wp-deep-blue' ),
					'fields' => $this->general_options()
				),
				array(
					'id'     => 'slider-frontpage-section',
					'title'  => esc_html__( 'Slider', 'wp-deep-blue' ),
					'fields' => $this->slider_options()
				),
				array(
				    'id'     => 'service-section',
				    'title'  => esc_html__( 'Service', 'wp-deep-blue' ),
				    'fields' => $this->service_options()
				),
				array(
				    'id'     => 'about-section',
				    'title'  => esc_html__( 'About', 'wp-deep-blue' ),
				    'fields' => $this->about_options()
				),
				array(
				    'id'     => 'brand-section',
				    'title'  => esc_html__( 'Brand', 'wp-deep-blue' ),
				    'fields' => $this->brand_options()
				),
				array(
				    'id'     => 'team-section',
				    'title'  => esc_html__( 'Team', 'wp-deep-blue' ),
				    'fields' => $this->team_options()
				),
				array(
				    'id'     => 'achievement-section',
				    'title'  => esc_html__( 'Achievement', 'wp-deep-blue' ),
				    'fields' => $this->achievement_options()
				),
				array(
				    'id'     => 'blog-section',
				    'title'  => esc_html__( 'Blog', 'wp-deep-blue' ),
				    'fields' => $this->blog_options()
				),
				array(
				    'id'     => 'testimonial-section',
				    'title'  => esc_html__( 'Testimonial', 'wp-deep-blue' ),
				    'fields' => $this->testimonial_options()
				),
				array(
				    'id'     => 'cta-section',
				    'title'  => esc_html__( 'Call to action', 'wp-deep-blue' ),
				    'fields' => $this->cta_options()
				)
			);

			$this->add( $panel );
		}

		public function general_options(){
			return array(
				array(
				    'id'      => 'show-content',
				    'label'   => esc_html__( 'Show Front Page Content', 'wp-deep-blue' ),
				    'type'    => 'toggle',
				    'default' => true
				),
				array(
				    'id'      => 'show-content-above',
				    'label'   => esc_html__( 'Show Content Above', 'wp-deep-blue' ),
				    'type'    => 'toggle',
				    'default' => false,
				    'active_callback' => array( __CLASS__, 'show_frontpage_content_above' )
				)
			);
		}

	    public function slider_options(){
			return array(
				array(
					'id'      => 'enable-slider',
					'label'   => esc_html__( 'Enable Slider', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => true
				),
				array(
					'id'    => 'slider-pages',
					'label' => esc_html__( 'Pages', 'wp-deep-blue' ),
					'type'  => 'page-repeater',
					'limit' => 3,
					'default' => '',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'slider-autoplay',
					'label' => esc_html__( 'Auto Play', 'wp-deep-blue' ),
					'type'  => 'toggle',
					'default' => false,
					'active_callback' => array( __CLASS__, 'module_callback' )
				),			
				array(
					'id'    => 'slider-dots',
					'label' => esc_html__( 'Dots', 'wp-deep-blue' ),
					'type'  => 'toggle',
					'default' => true,
					'active_callback' => array( __CLASS__, 'module_callback' )
				),			
				array(
					'id'    => 'slider-infinite',
					'label' => esc_html__( 'Infinite Scroll', 'wp-deep-blue' ),
					'type'  => 'toggle',
					'default' => true,
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'      => 'enable-slider-shortcode',
					'label'   => esc_html__( 'Enable Shortcode', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'slider-shortcode',
					'label' => esc_html__( 'Shortcode', 'wp-deep-blue' ),
					'type'  => 'text',
					'default' => '',
					'active_callback' => array( __CLASS__, 'module_shortcode_callback' )
				)
			);
		}

		public function about_options(){
			return array(
				array(
					'id'      => 'enable-about',
					'label'   => esc_html__( 'Enable', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'about-page',
					'label' => esc_html__( 'Page', 'wp-deep-blue' ),
					'type'  => 'dropdown-pages',
					'default' => '0',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'about-sub-text',
					'label' => esc_html__( 'Sub Title', 'wp-deep-blue' ),
					'type'  => 'text',
					'default' => esc_html__( 'About us' , 'wp-deep-blue' ),
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'about-btn-text',
					'label' => esc_html__( 'Button Text', 'wp-deep-blue' ),
					'type'  => 'text',
					'default' => esc_html__( 'Explore More' , 'wp-deep-blue' ),
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'      => 'enable-about-shortcode',
					'label'   => esc_html__( 'Enable Shortcode', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'about-shortcode',
					'label' => esc_html__( 'Shortcode', 'wp-deep-blue' ),
					'type'  => 'text',
					'active_callback' => array( __CLASS__, 'module_shortcode_callback' )
				)
			);
		}

		public function brand_options(){
			return array(
				array(
					'id'      => 'enable-brand',
					'label'   => esc_html__( 'Enable', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id' => 'brand-content-page',
					'label' => esc_html__( 'Content Page', 'wp-deep-blue' ),
					'type'  => 'dropdown-pages',
					'default' => '',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'brand-pages',
					'label' => esc_html__( 'Brand Pages', 'wp-deep-blue' ),
					'type'  => 'page-repeater',
					'limit' => 100,
					'default' => '',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'      => 'enable-brand-shortcode',
					'label'   => esc_html__( 'Enable Shortcode', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'brand-shortcode',
					'label' => esc_html__( 'Shortcode', 'wp-deep-blue' ),
					'type'  => 'text',
					'active_callback' => array( __CLASS__, 'module_shortcode_callback' )
				)
			);
		}

		public function team_options(){
			return array(
				array(
					'id'      => 'enable-team',
					'label'   => esc_html__( 'Enable', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'team-page',
					'label' => esc_html__( 'Content Page', 'wp-deep-blue' ),
					'type'  => 'dropdown-pages',
					'default' => '0',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id' => 'team-sub-text',
					'label' => esc_html__( 'Sub Text', 'wp-deep-blue' ),
					'type'  => 'text',
					'default' => esc_html__( 'Our staff', 'wp-deep-blue' ),
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'team-btn-text',
					'label' => esc_html__( 'Button Text', 'wp-deep-blue' ),
					'type'  => 'text',
					'default' => esc_html__( 'View All Member' , 'wp-deep-blue' ),
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'team-pages',
					'label' => esc_html__( 'Sub Pages', 'wp-deep-blue' ),
					'type'  => 'page-repeater',
					'description' => esc_html__( 'Recommended Title: Team Member Name', 'wp-deep-blue' ) . ' <span>' . esc_html__( 'Designation', 'wp-deep-blue' ) . '</span>',
					'limit' => 8,
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'team-col',
					'label' => esc_html__( 'Team to show in frontpage', 'wp-deep-blue' ),
					'type'  => 'number',
					'input_attrs' => array( 'max' => 4, 'min' => 1 ),
					'default' => 4,
					'active_callback' => array( __CLASS__, 'module_callback' )
				),		
				array(
					'id'    => 'team-archive-page',
					'label' => esc_html__( 'Select a Team Archive Page', 'wp-deep-blue' ),
					'type'  => 'dropdown-pages',
					'default' => 0,
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				
				array(
					'id'      => 'enable-team-shortcode',
					'label'   => esc_html__( 'Enable Shortcode', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'team-shortcode',
					'label' => esc_html__( 'Shortcode', 'wp-deep-blue' ),
					'type'  => 'text',
					'active_callback' => array( __CLASS__, 'module_shortcode_callback' )
				)
			);
		}

		public function service_options(){
			return array(
				array(
					'id'      => 'enable-service',
					'label'   => esc_html__( 'Enable', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'service-page',
					'label' => esc_html__( 'Content Page', 'wp-deep-blue' ),
					'type'  => 'dropdown-pages',
					'default' => '0',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'service-sub-text',
					'label' => esc_html__( 'Sub Text', 'wp-deep-blue' ),
					'type'  => 'text',
					'default' => esc_html__( 'Our services' , 'wp-deep-blue' ),
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'service-pages',
					'label' => esc_html__( 'Sub Pages', 'wp-deep-blue' ),
					'type'  => 'page-repeater',
					'limit' => 4,
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'service-btn-text',
					'label' => esc_html__( 'Button Text', 'wp-deep-blue' ),
					'type'  => 'text',
					'default' => esc_html__( 'Check our all services' , 'wp-deep-blue' ),
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'      => 'enable-service-shortcode',
					'label'   => esc_html__( 'Enable Shortcode', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'service-shortcode',
					'label' => esc_html__( 'Shortcode', 'wp-deep-blue' ),
					'type'  => 'text',
					'active_callback' => array( __CLASS__, 'module_shortcode_callback'  )
				)
			);
		}

		

		public function achievement_options(){
			return array(
				array(
					'id'      => 'enable-achievement',
					'label'   => esc_html__( 'Enable', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'achievement-page',
					'label' => esc_html__( 'Content Page', 'wp-deep-blue' ),
					'type'  => 'dropdown-pages',
					'default' => '0',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'achievement-sub-text',
					'label' => esc_html__( 'Sub Text', 'wp-deep-blue' ),
					'type'  => 'text',
					'default' => esc_html__( 'Our achievements' , 'wp-deep-blue' ),
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'achievement-pages',
					'label' => esc_html__( 'Sub Pages', 'wp-deep-blue' ),
					'type'  => 'page-repeater',
					'limit' => 3,
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'      => 'enable-achievement-shortcode',
					'label'   => esc_html__( 'Enable Shortcode', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'achievement-shortcode',
					'label' => esc_html__( 'Shortcode', 'wp-deep-blue' ),
					'type'  => 'text',
					'active_callback' => array( __CLASS__, 'module_shortcode_callback' )
				)
			);
		}

		public function blog_options(){
			return array(
				array(
					'id'      => 'enable-blog',
					'label'   => esc_html__( 'Enable', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'blog-page',
					'label' => esc_html__( 'Content Page', 'wp-deep-blue' ),
					'type'  => 'dropdown-pages',
					'default' => '0',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id' => 'blog-sub-text',
					'label' => esc_html__( 'Sub Text', 'wp-deep-blue' ),
					'type' => 'text',
					'default' => esc_html__( 'Latest news', 'wp-deep-blue' ),
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'blog-col',
					'label' => esc_html__( 'Total column per row', 'wp-deep-blue' ),
					'type'  => 'number',
					'input_attrs' => array( 'max' => 4, 'min' => 1 ),
					'default' => 4,
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'      => 'enable-blog-shortcode',
					'label'   => esc_html__( 'Enable Shortcode', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'blog-shortcode',
					'label' => esc_html__( 'Shortcode', 'wp-deep-blue' ),
					'type'  => 'text',
					'active_callback' => array( __CLASS__, 'module_shortcode_callback' )
				)
			);
		}

		public function testimonial_options(){
			return array(
				array(
					'id'      => 'enable-testimonial',
					'label'   => esc_html__( 'Enable', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'testimonial-page',
					'label' => esc_html__( 'Content Page', 'wp-deep-blue' ),
					'type'  => 'dropdown-pages',
					'default' => '0',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'      => 'testimonial-sub-text',
					'label'   => esc_html__( 'Sub Text', 'wp-deep-blue' ),
					'type'    => 'text',
					'default' => esc_html__( 'Testimonials', 'wp-deep-blue' ),
					'active_callback' => array( __CLASS__, 'module_callback' )
 				),
				array(
					'id'    => 'testimonial-pages',
					'label' => esc_html__( 'Sub Pages', 'wp-deep-blue' ),
					'type'  => 'page-repeater',
					'limit' => 3,
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'      => 'enable-testimonial-shortcode',
					'label'   => esc_html__( 'Enable Shortcode', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'testimonial-shortcode',
					'label' => esc_html__( 'Shortcode', 'wp-deep-blue' ),
					'type'  => 'text',
					'active_callback' => array( __CLASS__, 'module_shortcode_callback' )
				)
			);
		}

		public function cta_options(){
			return array(
				array(
					'id'      => 'enable-cta',
					'label'   => esc_html__( 'Enable', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'cta-page',
					'label' => esc_html__( 'Content Page', 'wp-deep-blue' ),
					'type'  => 'dropdown-pages',
					'default' => '0',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'    => 'cta-contact-form-shortcode',
					'label' => esc_html__( 'Contact Form Shortcode', 'wp-deep-blue' ),
					'type'  => 'text',
					'default' => '',
					'active_callback' => array( __CLASS__, 'module_callback' )
				),
				array(
					'id'      => 'enable-cta-shortcode',
					'label'   => esc_html__( 'Enable Shortcode', 'wp-deep-blue' ),
					'type'    => 'toggle',
					'default' => false
				),
				array(
					'id'    => 'cta-shortcode',
					'label' => esc_html__( 'Shortcode', 'wp-deep-blue' ),
					'type'  => 'text',
					'active_callback' => array( __CLASS__, 'module_shortcode_callback' )
				)
			);
		}

		

		

		public static function show_frontpage_content_above(){
	        return self::get( 'show-content' );
	    }

	    public static function get_module_name( $control ){
	    	$id = str_replace( 'wp-deep-blue-', '', $control->id );
	    	$arr = explode( '-', $id );
	    	if( is_array( $arr ) && isset( $arr[0] ) ){
	    		return $arr[0];
	    	}

	    	return false;
	    }
	    
	    public static function module_callback( $control ){
	    	$name = self::get_module_name( $control );
	    	if( $name ){
	    		return self::get( "enable-{$name}" );
	    	}

	    	return true;
	    }

	    public static function module_shortcode_callback( $control ){
	    	$name = self::get_module_name( $control );
	    	if( $name ){
	    		return self::get( "enable-{$name}-shortcode" );
	    	}
	    	return true;
	    }
	}
}
