<?php
/**
 * Shows a breadcrumb for all types of pages.  This is a wrapper function for the Breadcrumb_Trail class,
 * which should be used in theme templates.
 *
 * @since WP Deep Blue 1.0
 */
if( !function_exists( 'wp_deep_blue_breadcrumb_trail') ){
	function wp_deep_blue_breadcrumb_trail( $args = array() ) {

		$breadcrumb = apply_filters( 'wp_deep_blue_breadcrumb_trail_object', null, $args );

		if ( !is_object( $breadcrumb ) ) 
			$breadcrumb = new WP_Deep_Blue_Breadcrumb_Trail( $args );

		return $breadcrumb->trail();
	}
}

/**
 *  Lists of files to be loaded for theme options module
 *
 * @since WP Deep Blue 1.0
 */
function wp_deep_blue_breadcrumb_files( $files ){

    $new_files = array( 'class-breadcrumb.php' );

    return array_merge( $files, $new_files );
}
add_filter( 'wp_deep_blue_modules_breadcrumb', 'wp_deep_blue_breadcrumb_files' );