<?php
/**
 * The Header for our theme.
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 * @since WP Deep Blue 1.0 
 */
$preloader = wp_deep_blue_get( 'pre-loader' );
$search = wp_deep_blue_get( 'enable-search' );
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php echo wp_deep_blue_schema('body'); body_class(); ?>>

	<?php wp_body_open(); ?>

	<a class="skip-link screen-reader-text" href="#site-content">
		<?php esc_html_e( 'Skip to content', 'wp-deep-blue' ); ?>
	</a>
	
	<?php if ( $preloader ) : ?>	
		<div id="loader-wrapper">
			<span id="loader">
				<span class="loader-inner"></span>
			</span>
		</div>
	<?php endif; ?>

	<header id="site-header" <?php echo wp_deep_blue_schema( 'header' ); ?> class="site-header">
		<div class="container">
			<div class="row header-wrapper">
				<div class="col-6 col-sm-3">
					<div class="header-titles">
						<?php the_custom_logo(); ?>
						<div class="site-branding">
							<?php if ( is_front_page() || is_archive() ) :
							?>
								<h1 class="site-title">
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
										<?php bloginfo( 'name' ); ?>
									</a>
								</h1>
							<?php
							else :
							?>
								<p class="site-title">
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
										<?php bloginfo( 'name' ); ?>
									</a>
								</p>
							<?php
							endif;
							$description = get_bloginfo( 'description', 'display' );
							if ($description || is_customize_preview()) :
							?>
								<p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<div class="col-6 col-sm-9">
					<div class="header-navigation-wrapper">
						<nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e( 'Horizontal', 'wp-deep-blue' ); ?>" role="navigation">
							<?php
							wp_nav_menu(array(
								'theme_location' => 'primary',
								'echo'           => true,
								'container'      => false,
								'menu_id'        => 'primary-menu',
								'menu_class'     => 'navigation clearfix'
							));
							?>
						</nav><!-- .primary-menu-wrapper -->

						<?php if( $search ): ?>
							<a href="#" class="wp-deep-blue-search-icon fst-toggle-search">
								<svg width="20" height="20" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M225.474,0C101.151,0,0,101.151,0,225.474c0,124.33,101.151,225.474,225.474,225.474c124.33,0,225.474-101.144,225.474-225.474C450.948,101.151,349.804,0,225.474,0z M225.474,409.323c-101.373,0-183.848-82.475-183.848-183.848S124.101,41.626,225.474,41.626s183.848,82.475,183.848,183.848S326.847,409.323,225.474,409.323z"></path><path d="M505.902,476.472L386.574,357.144c-8.131-8.131-21.299-8.131-29.43,0c-8.131,8.124-8.131,21.306,0,29.43l119.328,119.328c4.065,4.065,9.387,6.098,14.715,6.098c5.321,0,10.649-2.033,14.715-6.098C514.033,497.778,514.033,484.596,505.902,476.472z"></path></svg>
							</a>
						<?php endif; ?>
						<a href="#" class="fst-mmenu-toggler" id="menu-toggler">
							<span></span>
							<span></span>
							<span></span>
							<span></span>
						</a>
					</div>
				</div>
			</div>
		</div>
	</header>
