<?php

/**
 * The template for displaying the footer.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 * @since WP Deep Blue 1.0
 */
$show_widget = true;
if (is_page() || is_single() || is_home()) {


	$id = wp_deep_blue_get_page_id();

	if ('on' == get_post_meta( $id, 'wp-deep-blue-disable-footer-widget', true )) {
		$show_widget = false;
	}
}

$show_social_menu = wp_deep_blue_get( 'footer-social-menu' );
$footer_text = wp_deep_blue_get( 'footer-copyright-text' );
?>
<section <?php echo wp_deep_blue_schema('footer'); ?> class="wp-deep-blue-footer-wrapper">

	<?php if ($show_widget) : ?>
		<footer class="wp-deep-blue-footer-wrapper-inner footer-widget">
			<div class="container">
				<div class="row">
					<div class="col-md-6 col-lg-3">
						<div class="footer-widget-wrapper"><?php dynamic_sidebar('wp-deep-blue-footer-widget-1'); ?></div>
					</div>
					<div class="col-md-6 col-lg-3">
						<div class="footer-widget-wrapper"><?php dynamic_sidebar('wp-deep-blue-footer-widget-2'); ?></div>
					</div>
					<div class="col-md-6 col-lg-3">
						<div class="footer-widget-wrapper"><?php dynamic_sidebar('wp-deep-blue-footer-widget-3'); ?></div>
					</div>
					<div class="col-md-6 col-lg-3">
						<div class="footer-widget-wrapper"><?php dynamic_sidebar('wp-deep-blue-footer-widget-4'); ?></div>
					</div>
				</div>
			</div>
		</footer>
	<?php endif; ?>

	<div class="container">
		<div class="row">
			<div class="wp-deep-blue-copy-right d-sm-flex text-center">
				<div class="mb-2 mb-sm-0">
					<?php echo esc_html($footer_text); ?>
				</div>
				<div class="wp-deep-blue-credit-link">
					<?php esc_html_e('Created By:', 'wp-deep-blue') ?>
					<a class="pl-1" href="<?php echo esc_url('//www.fanseethemes.com'); ?>" target="_blank">
						<?php esc_html_e('Fansee Themes', 'wp-deep-blue'); ?>
					</a>
				</div>
			</div>
		</div>
	</div>

</section>
<?php wp_footer(); ?>
</body>

</html>