+(function ($) {

    var Starter = /** @class */ (function () {

        /** 
         * Constructor function initialize the all plugins
         */
        function Starter() {
            this.initFstMmenu();
            this.initPopupSearch();
            this.initShowNavOnScreen();

            if( '1' == WPDEEPBLUE.enable_scroll_top ){
                this.InitScrollTop();
            }

            this.initCustomInput();

            if( '1' == WPDEEPBLUE.cookie_consent ){
                this.initCookiePolicy({
                    acceptButtonText: 'Allows',
                    declineuttonText: 'Decline',
                    CookiePolicyContentText: 'We use third-party cookies in order to personalize your site experienceasdfad'
                });
            }

            /* Product single page */
            this.initProductZoom();
            this.initProductSlider();
        };

        /** 
         * Initialize the cookie policy popup
         * @returns {void}
         */
        Starter.prototype.initCookiePolicy = function(){
            var config = {
                acceptButtonCustomClass: 'wp-deep-blue-btn-primary',
                declineButtonCustomClass: 'wp-deep-blue-btn-secondary',
            }
            new FstCookiesPolicy(config);
        }

        /** 
         * Intialize the custom input 
         */
        Starter.prototype.initCustomInput = function(){
            const config= {
                selector: 'input[type="number"]',
            }
            new FstCustomInputNumber(config);
        }   

        /** 
         * Initialize the scroll top plugin
         */
        Starter.prototype.InitScrollTop = function(){
            new FstScrolltop();
        };

        /**
         * Initialize the mmenu
         */
        Starter.prototype.initFstMmenu = function(){

            var mmenuConfig = { width: 320 },
                $selector = $('.primary-menu-wrapper');

            if($selector.length){
                $selector.fstMmenu(mmenuConfig);
            }
        };


        /** 
         * Initialize the popup search
         */
        Starter.prototype.initPopupSearch = function(){
            var $selector = $('.fst-toggle-search');
            if($selector.length){
                $selector.fstPopupSearch();
            }
        };


        /** 
         * Initialize show navigation in screen
         */
        Starter.prototype.initShowNavOnScreen = function(){
            var selector = '#primary-menu ul';
            var $selector = $(selector);
            if($selector.length){
                new FstShowNavOnScreen(selector);
            }
        };

        /** 
         * Initialize the zoom plugin for the zoom the product in
         * Product single page
         */
        Starter.prototype.initProductZoom = function(){
            var $productImage = $('.woocommerce-product-gallery__wrapper > div:first-child');
            $productImage.length && $productImage.zoom({
                magnify: 1,
                // on:'grab',
                onZoomIn: true,
                onZoomOut: true,
            });
        };

        /** 
         * Initialize the single page plugins
         */
        Starter.prototype.initProductSlider = function(){
            var $productGallery = $('.woocommerce-product-gallery__wrapper' );
    
            var productGalleryClassName = 'woocommerce-product-gallery';
            var $productGalleryList = $('<div />', { 'class': productGalleryClassName });
    
            $('.woocommerce-product-gallery__wrapper > div:not(:first-child)').each(function (i, ele) {
                $productGalleryList.append(ele);
            });
    
            $productGallery.append($productGalleryList);
    
            if ($productGalleryList.length) {
                $productGalleryList.slick({
                    centerPadding: '60px',
                    slidesToShow: 4,
                    slidesToScroll: 4,
                    nextArrow: '<div class="slick-prev"></div>',
                    prevArrow: '<div></div>'
                });
            }
    
            $('a', $productGalleryList).on('click', function (e) {
                var imgSrc = $(this).attr('href'); //.split('/').slice(-1);
                var img = $(this).parents('.' + productGalleryClassName).prev().find('img');
                var aTag = $(img).parent();
                $(img).attr('src', imgSrc);
                $(aTag).attr('href', imgSrc);
                $(img).removeAttr('srcset');
                return false;
            })
        };

        return Starter;

    }());


    $(document).ready( function(){
        new Starter();
    });

})(jQuery)

