<?php 

/*******************************************************************
Register Post Type
********************************************************************/

function witr_slider_post_type() 
{
	$labels = array(
		'name'               => _x( 'Sliders', 'post type general name', 'poket' ),
		'singular_name'      => _x( 'Slider', 'post type singular name', 'poket' ),
		'menu_name'          => _x( 'Nivo Slider', 'admin menu', 'poket' ),
		'name_admin_bar'     => _x( 'Slider', 'add new on admin bar', 'poket' ),
		'add_new'            => _x( 'Add New', 'slider', 'poket' ),
		'add_new_item'       => __( 'Add New Slider', 'poket' ),
		'new_item'           => __( 'New Slider', 'poket' ),
		'edit_item'          => __( 'Edit Slider', 'poket' ),
		'view_item'          => __( 'View Slider', 'poket' ),
		'all_items'          => __( 'All Slider', 'poket' ),
		'search_items'       => __( 'Search Slider', 'poket' ),
		'parent_item_colon'  => __( 'Parent Slider:', 'poket' ),
		'not_found'          => __( 'No sliders found.', 'poket' ),
		'not_found_in_trash' => __( 'No sliders found in Trash.', 'poket' ),
		'featured_image'        => __( 'Background Image', 'poket' ),
		'set_featured_image'    => __( 'Set BG image', 'poket' ),
		'remove_featured_image' => _x( 'Remove BG image', 'poket' ),
		'use_featured_image'    => _x( 'Use as BG image', 'poket' ),
		
	);
	
	$args = array(
		
	
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          =>'dashicons-format-gallery',
		'exclude_from_search'=> true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'slider' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array('title', 'thumbnail','page-attributes')
	);
	
	register_post_type( 'em_slider' , $args );

}
add_action('init', 'witr_slider_post_type');



/* service */
function witr_service_post_type() 
{
	$labels = array(
		'name'               => _x( 'Service', 'post type general name', 'poket' ),
		'singular_name'      => _x( 'Service', 'post type singular name', 'poket' ),
		'menu_name'          => _x( 'Post Service', 'admin menu', 'poket' ),
		'name_admin_bar'     => _x( 'Service', 'add new on admin bar', 'poket' ),
		'add_new'            => _x( 'Add New', 'Service', 'poket' ),
		'add_new_item'       => __( 'Add New Service', 'poket' ),
		'new_item'           => __( 'New Service', 'poket' ),
		'edit_item'          => __( 'Edit Service', 'poket' ),
		'view_item'          => __( 'View Service', 'poket' ),
		'all_items'          => __( 'All Service', 'poket' ),
		'search_items'       => __( 'Search Service', 'poket' ),
		'parent_item_colon'  => __( 'Parent Service:', 'poket' ),
		'not_found'          => __( 'No Service found.', 'poket' ),
		'not_found_in_trash' => __( 'No Service found in Trash.', 'poket' )
	);
	
	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          =>'dashicons-images-alt2',		
		'exclude_from_search'=> true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'em_services' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array('title','editor', 'thumbnail')
	);
	
	register_post_type( 'em_service' , $args );
	
	/*$labels = array(
		'name'              => _x( 'Categories', 'taxonomy general name', 'poket' ),
		'singular_name'     => _x( 'Category', 'taxonomy singular name', 'poket' ),
		'search_items'      => __( 'Search Categories', 'poket' ),
		'all_items'         => __( 'All Categories', 'poket' ),
		'parent_item'       => __( 'Parent Category', 'poket' ),
		'parent_item_colon' => __( 'Parent Category:', 'poket' ),
		'edit_item'         => __( 'Edit Category', 'poket' ),
		'update_item'       => __( 'Update Category', 'poket' ),
		'add_new_item'      => __( 'Add New Category', 'poket' ),
		'new_item_name'     => __( 'New Category Name', 'poket' ),
		'menu_name'         => __( 'Categories', 'poket' ),
	);

	$args = array(
		'public'            => false,
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => false,
		'query_var'         => false,
		'rewrite'           => array( 'slug' => 'service-category' ),
	);*/
	
	register_taxonomy( 'em_service_cat', array( 'em_service' ), $args );
	
}
add_action('init', 'witr_service_post_type');
/* portfolio */

function witr_portfolio_post_type() 
{
	$labels = array(
		'name'               => _x( 'Portfolio', 'post type general name', 'poket' ),
		'singular_name'      => _x( 'Portfolio', 'post type singular name', 'poket' ),
		'menu_name'          => _x( 'Post Portfolio', 'admin menu', 'poket' ),
		'name_admin_bar'     => _x( 'Portfolio', 'add new on admin bar', 'poket' ),
		'add_new'            => _x( 'Add New', 'Portfolio', 'poket' ),
		'add_new_item'       => __( 'Add New Portfolio', 'poket' ),
		'new_item'           => __( 'New Portfolio', 'poket' ),
		'edit_item'          => __( 'Edit Portfolio', 'poket' ),
		'view_item'          => __( 'View Portfolio', 'poket' ),
		'all_items'          => __( 'All Portfolio', 'poket' ),
		'search_items'       => __( 'Search Portfolio', 'poket' ),
		'parent_item_colon'  => __( 'Parent Portfolio:', 'poket' ),
		'not_found'          => __( 'No Portfolio found.', 'poket' ),
		'not_found_in_trash' => __( 'No Portfolio found in Trash.', 'poket' )
	);
	
	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          =>'dashicons-images-alt2',		
		'exclude_from_search'=> true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'em_portfolios' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array('title','editor', 'thumbnail')
	);
	
	register_post_type( 'em_portfolio' , $args );
	
	$labels = array(
		'name'              => _x( 'Categories', 'taxonomy general name', 'poket' ),
		'singular_name'     => _x( 'Category', 'taxonomy singular name', 'poket' ),
		'search_items'      => __( 'Search Categories', 'poket' ),
		'all_items'         => __( 'All Categories', 'poket' ),
		'parent_item'       => __( 'Parent Category', 'poket' ),
		'parent_item_colon' => __( 'Parent Category:', 'poket' ),
		'edit_item'         => __( 'Edit Category', 'poket' ),
		'update_item'       => __( 'Update Category', 'poket' ),
		'add_new_item'      => __( 'Add New Category', 'poket' ),
		'new_item_name'     => __( 'New Category Name', 'poket' ),
		'menu_name'         => __( 'Categories', 'poket' ),
	);

	$args = array(
		'public'            => false,
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => false,
		'query_var'         => false,
		'rewrite'           => array( 'slug' => 'portfolio-category' ),
	);
	
	register_taxonomy( 'em_portfolio_cat', array( 'em_portfolio' ), $args );
	
}
add_action('init', 'witr_portfolio_post_type');

// event
function witr_event_post_type() 
{
	$labels = array(
		'name'               => _x( 'Event', 'post type general name', 'poket' ),
		'singular_name'      => _x( 'Event', 'post type singular name', 'poket' ),
		'menu_name'          => _x( 'Post Event', 'admin menu', 'poket' ),
		'name_admin_bar'     => _x( 'Event', 'add new on admin bar', 'poket' ),
		'add_new'            => _x( 'Add New', 'Event', 'poket' ),
		'add_new_item'       => __( 'Add New Event', 'poket' ),
		'new_item'           => __( 'New Event', 'poket' ),
		'edit_item'          => __( 'Edit Event', 'poket' ),
		'view_item'          => __( 'View Event', 'poket' ),
		'all_items'          => __( 'All Event', 'poket' ),
		'search_items'       => __( 'Search Event', 'poket' ),
		'parent_item_colon'  => __( 'Parent Event:', 'poket' ),
		'not_found'          => __( 'No Event found.', 'poket' ),
		'not_found_in_trash' => __( 'No Event found in Trash.', 'poket' )
	);
	
	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          =>'dashicons-megaphone',		
		'exclude_from_search'=> true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'em_event' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array('title','editor', 'thumbnail')
	);
	
	register_post_type( 'em_event' , $args );
	

}
add_action('init', 'witr_event_post_type');


// team
function witr_team_post_type() 
{
	$labels = array(
		'name'               => _x( 'Team', 'post type general name', 'poket' ),
		'singular_name'      => _x( 'Team', 'post type singular name', 'poket' ),
		'menu_name'          => _x( 'Post Team', 'admin menu', 'poket' ),
		'name_admin_bar'     => _x( 'Team', 'add new on admin bar', 'poket' ),
		'add_new'            => _x( 'Add New', 'Team', 'poket' ),
		'add_new_item'       => __( 'Add New Team', 'poket' ),
		'new_item'           => __( 'New Team', 'poket' ),
		'edit_item'          => __( 'Edit Team', 'poket' ),
		'view_item'          => __( 'View Team', 'poket' ),
		'all_items'          => __( 'All Team', 'poket' ),
		'search_items'       => __( 'Search Team', 'poket' ),
		'parent_item_colon'  => __( 'Parent Team:', 'poket' ),
		'not_found'          => __( 'No Team found.', 'poket' ),
		'not_found_in_trash' => __( 'No Team found in Trash.', 'poket' )
	);
	
	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          =>'dashicons-megaphone',		
		'exclude_from_search'=> true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'em_team' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array('title','editor', 'thumbnail')
	);
	
	register_post_type( 'em_team' , $args );
	
	/*$labels = array(
		'name'              => _x( 'Categories', 'taxonomy general name', 'poket' ),
		'singular_name'     => _x( 'Category', 'taxonomy singular name', 'poket' ),
		'search_items'      => __( 'Search Categories', 'poket' ),
		'all_items'         => __( 'All Categories', 'poket' ),
		'parent_item'       => __( 'Parent Category', 'poket' ),
		'parent_item_colon' => __( 'Parent Category:', 'poket' ),
		'edit_item'         => __( 'Edit Category', 'poket' ),
		'update_item'       => __( 'Update Category', 'poket' ),
		'add_new_item'      => __( 'Add New Category', 'poket' ),
		'new_item_name'     => __( 'New Category Name', 'poket' ),
		'menu_name'         => __( 'Categories', 'poket' ),
	);

	$args = array(
		'public'            => false,
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'show_in_nav_menus' => false,
		'query_var'         => false,
		'rewrite'           => array( 'slug' => 'team-category' ),
	);*/
	
	register_taxonomy( 'em_team_cat', array( 'em_team' ), $args );	
	
}
add_action('init', 'witr_team_post_type');


// testimonial
function witr_testimonial_post_type() 
{
	$labels = array(
		'name'               => _x( 'Testimonials', 'post type general name', 'poket' ),
		'singular_name'      => _x( 'Testimonial', 'post type singular name', 'poket' ),
		'menu_name'          => _x( 'Post Testimonial', 'admin menu', 'poket' ),
		'name_admin_bar'     => _x( 'Testimonial', 'add new on admin bar', 'poket' ),
		'add_new'            => _x( 'Add New', 'Testimonial', 'poket' ),
		'add_new_item'       => __( 'Add New Testimonial', 'poket' ),
		'new_item'           => __( 'New Testimonial', 'poket' ),
		'edit_item'          => __( 'Edit Testimonial', 'poket' ),
		'view_item'          => __( 'View Testimonial', 'poket' ),
		'all_items'          => __( 'All Testimonial', 'poket' ),
		'search_items'       => __( 'Search Testimonial', 'poket' ),
		'parent_item_colon'  => __( 'Parent Testimonial:', 'poket' ),
		'not_found'          => __( 'No Testimonials found.', 'poket' ),
		'not_found_in_trash' => __( 'No Testimonials found in Trash.', 'poket' )
	);
	
	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          =>'dashicons-format-status',		
		'exclude_from_search'=> true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'em_testimonial' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array('title','editor', 'thumbnail')
	);
	
	register_post_type( 'em_testimonial' , $args );
}
add_action('init', 'witr_testimonial_post_type');


// Post Tab
function witr_post_tabpost_type() 
{
	$labels = array(
		'name'               => _x( 'Posts Tab', 'post type general name', 'poket' ),
		'singular_name'      => _x( 'Post Tab', 'post type singular name', 'poket' ),
		'menu_name'          => _x( 'Post Tab', 'admin menu', 'poket' ),
		'name_admin_bar'     => _x( 'Post Tab', 'add new on admin bar', 'poket' ),
		'add_new'            => _x( 'Add New', 'Post Tab', 'poket' ),
		'add_new_item'       => __( 'Add New Post Tab', 'poket' ),
		'new_item'           => __( 'New Post Tab', 'poket' ),
		'edit_item'          => __( 'Edit Post Tab', 'poket' ),
		'view_item'          => __( 'View Post Tab', 'poket' ),
		'all_items'          => __( 'All Post Tab', 'poket' ),
		'search_items'       => __( 'Search Post Tab', 'poket' ),
		'parent_item_colon'  => __( 'Parent Post Tab:', 'poket' ),
		'not_found'          => __( 'No Post Tab found.', 'poket' ),
		'not_found_in_trash' => __( 'No Post Tab found in Trash.', 'poket' )
	);
	
	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'menu_icon'          =>'dashicons-welcome-add-page',		
		'exclude_from_search'=> true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'em_tab' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array('title','editor', 'thumbnail')
	);
	
	register_post_type( 'em_tab' , $args );
}
add_action('init', 'witr_post_tabpost_type');

