{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

{capture name=path}{l s='Suppliers'}{/capture}
{include file="$tpl_dir./breadcrumb.tpl"}

<h1>{l s='Suppliers'}</h1>

{if isset($errors) AND $errors}
	{include file="$tpl_dir./errors.tpl"}
{else}
	<p class="warning">{strip}
		<span>
			{if $nbSuppliers == 0}{l s='There are no suppliers.'}
			{else}
				{if $nbSuppliers == 1}{l s='There is'}{else}{l s='There are'}{/if}&nbsp;
				{$nbSuppliers}&nbsp;
				{if $nbSuppliers == 1}{l s='supplier.'}{else}{l s='suppliers.'}{/if}
			{/if}
		</span>{/strip}
	</p>

	{if $nbSuppliers > 0}
		<ul id="suppliers_list">
		{if isset($suppliers_list)}{assign var=suppliers value=$suppliers_list}{else}{assign var=suppliers value=$suppliers}{/if}
		{foreach from=$suppliers item=supplier name=suppliers}
			<li class="{if $supplier@first}first_item{elseif $supplier@last}last_item{else}item{/if}">
				<div class="left_side">
					<!-- logo -->
					<div class="logo">
					{if $supplier.nb_products > 0}
					<a href="{$link->getsupplierLink($supplier.id_supplier, $supplier.link_rewrite)|escape:'html':'UTF-8'}" title="{$supplier.name|escape:'html':'UTF-8'}" class="lnk_img">
					{/if}
						<img class="replace-2x" src="{$img_sup_dir}{$supplier.id_supplier|escape:'html':'UTF-8'}-medium.jpg" alt="{$supplier.name|escape:'html':'UTF-8'}" {if isset($imgMediumSize)}style="height:{$imgMediumSize.height}px;width:{$imgMediumSize.width}px"{/if} />
					{if $supplier.nb_products > 0}
					</a>
					{/if}
					</div>
					<!-- name -->
					<h3>
						{if $supplier.nb_products > 0}
						<a href="{$link->getsupplierLink($supplier.id_supplier, $supplier.link_rewrite)|escape:'html':'UTF-8'}" title="{$supplier.name|escape:'html':'UTF-8'}">
						{/if}
						{$supplier.name|truncate:60:'...'|escape:'html':'UTF-8'}
						{if $supplier.nb_products > 0}
						</a>
						{/if}
					</h3>
					<p class="description">
						{$supplier.description|strip_tags:'UTF-8'|truncate:170:'...'}
					</p>
				</div>
				<span class="bold">{if $supplier.nb_products == 0}{l s='No products'}{else}{$supplier.nb_products|intval}&nbsp;{if $supplier.nb_products == 1}{l s='product'}{else}{l s='products'}{/if}{/if}</span>

				<div class="right_side">
				{if $supplier.nb_products > 0}
					<a class="button" href="{$link->getsupplierLink($supplier.id_supplier, $supplier.link_rewrite)|escape:'html':'UTF-8'}" title="{l s='View products'}">{l s='View products'}</a>
				{/if}
				</div>
			</li>
		{/foreach}
		</ul>
		
		<div class="content_sortPagiBar">
			<div class="sortPagiBar">
				{include file="$tpl_dir./pagination.tpl"}
			</div>
		</div>
		
	{/if}
{/if}