{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

<!-- MODULE Block best sellers -->
<div id="best-sellers_block_right" class="block products_block">
	<p class="title_block"><a href="{$link->getPageLink('best-sales.php')}">{l s='Top sellers' mod='blockbestsellers'}</a></p>
	<div class="block_content">
		{if $best_sellers|@count > 0}
			<ul class="products clearfix">
				{foreach from=$best_sellers item=product name=myLoop}
					{if $smarty.foreach.myLoop.iteration <= 2}
						<li class="{if $smarty.foreach.myLoop.first}first_item{elseif $smarty.foreach.myLoop.last}last_item{else}item{/if}">
							<a href="{$product.link}" title="{$product.name|escape:'html':'UTF-8'}" class="product_image">
								<span class="number">{$smarty.foreach.myLoop.iteration}</span>
								<img class="replace-2x" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'small')}" alt="{$product.name|escape:'html':'UTF-8'}" {if isset($imgSmallSize)}style="height:{$imgSmallSize.height}px;width:{$imgSmallSize.width}px"{/if} />
							</a>
							<div class="product_content">
								<p class="product_name"><a href="{$product.link}" title="{$product.name|escape:'html':'UTF-8'}">{$product.name|truncate:40:'...'|escape:'html':'UTF-8'}</a></p>
								<p class="product_price">{$product.price}</p>
								{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
									<div class="aeuc_block">{hook h="displayProductPriceBlock" product=$product type="price"}</div>
								{/if}
							</div>
						</li>
					{/if}
				{/foreach}
			</ul>
			<p class="lnk"><a href="{$link->getPageLink('best-sales.php')}" title="{l s='All best sellers' mod='blockbestsellers'}" class="button_large">{l s='All best sellers' mod='blockbestsellers'}</a></p>
		{else}
			<p>{l s='No best sellers at this time' mod='blockbestsellers'}</p>
		{/if}
	</div>
</div>
<!-- /MODULE Block best sellers -->