{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

<!-- MODULE Block best sellers HOME -->
<div id="best-sellers_block_center" class="block products_block tab-pane">
	<h4><a href="{$link->getPageLink('best-sales.php')}" title="{l s='Top sellers' mod='blockbestsellers'}">{l s='Top sellers' mod='blockbestsellers'}</a></h4>
	{if isset($best_sellers) AND $best_sellers}
		<div class="block_content">
			{assign var='nbItemsPerLine' value=4}
			<ul class="clearfix">
				{foreach from=$best_sellers item=product name=myLoop}
					{if $smarty.foreach.myLoop.iteration <= 4}
						<li class="ajax_block_product {if $smarty.foreach.myLoop.first}first_item{elseif $smarty.foreach.myLoop.last}last_item{else}item{/if}{if $smarty.foreach.myLoop.iteration%$nbItemsPerLine == 0} last_item_of_line{elseif $smarty.foreach.myLoop.iteration%$nbItemsPerLine == 1} first_item_of_line{/if} span3">
							<a href="{$product.link}" title="{$product.name|escape:'html':'UTF-8'}" class="product_image"><img class="replace-2x" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'home')}" alt="{$product.name|escape:'html':'UTF-8'}" {if isset($imgHomeSize)}style="width:{$imgHomeSize.width}px"{/if} /></a>
							<h5><a href="{$product.link}" title="{$product.name|escape:'html':'UTF-8'}">{$product.name|truncate:40:'...'|escape:'html':'UTF-8'}</a></h5>
							<div class="product_desc">{$product.description_short|strip_tags:'UTF-8'|truncate:100:'...'}</div>
							<p class="price_container"><span class="price">{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}{hook h="displayProductPriceBlock" product=$product type="before_price"}{/if}{$product.price}</span></p>
						</li>
					{/if}
				{/foreach}
			</ul>
		</div>
	{else}
		<p>{l s='No best sellers at this time' mod='blockbestsellers'}</p>
	{/if}
</div>
<!-- /MODULE Block best sellers HOME -->