{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

<!DOCTYPE html>
<!--[if IE 8]><html class="ie8" lang="{$lang_iso}"><![endif]-->
<html lang="{$lang_iso}">

<!-- 
 * Template Prestashop DiscountShop V.3.7.3
 * @author    Prestacrea
 * @copyright Prestacrea
 * @website   http://www.prestacrea.com
-->

	<head>
		<meta charset="utf-8" />
		<title>{$meta_title|escape:'html':'UTF-8'}</title>
		{if isset($meta_description) AND $meta_description}
			<meta name="description" content="{$meta_description|escape:'html':'UTF-8'}" />
		{/if}
		{if isset($meta_keywords) AND $meta_keywords}
			<meta name="keywords" content="{$meta_keywords|escape:'html':'UTF-8'}" />
		{/if}
		<meta name="generator" content="PrestaShop" />
		<meta name="robots" content="{if isset($nobots)}no{/if}index,{if isset($nofollow) && $nofollow}no{/if}follow" />
		{if isset($ptm_responsive) AND $ptm_responsive == 1}
			<meta name="viewport" content="initial-scale=1, minimum-scale=1, maximum-scale=1, width=device-width" />
		{/if}
		<link rel="icon" type="image/vnd.microsoft.icon" href="{if isset($favicon_url)}{$favicon_url}?{$img_update_time}{else}{$img_ps_dir}favicon.ico?{$img_update_time}{/if}" />
		<link rel="shortcut icon" type="image/x-icon" href="{if isset($favicon_url)}{$favicon_url}?{$img_update_time}{else}{$img_ps_dir}favicon.ico?{$img_update_time}{/if}" />
		{if version_compare($smarty.const._PS_VERSION_,'1.6','<')}
			<script type="text/javascript">
				var baseDir = '{$content_dir}';
				{if isset($base_uri)}var baseUri = '{$base_uri}';{/if}
				var static_token = '{$static_token}';
				var token = '{$token}';
				var priceDisplayPrecision = {$priceDisplayPrecision*$currency->decimals};
				var priceDisplayMethod = {$priceDisplay};
				var roundMode = {$roundMode};
				var prestashop_version = {if version_compare($smarty.const._PS_VERSION_,'1.5','>=')}1.5{else if version_compare($smarty.const._PS_VERSION_,'1.4','>=')}1.4{/if};
				var responsive = {if isset($ptm_responsive) AND $ptm_responsive == 1}1{else}0{/if};
			</script>
		{/if}
		{if isset($css_files)}
			{foreach from=$css_files key=css_uri item=media}
				<link href="{$css_uri}" rel="stylesheet" type="text/css" media="{$media}" />
			{/foreach}
		{/if}
		{if isset($ptm_googlefont)}
			<link href='https://fonts.googleapis.com/css?family={$ptm_googlefont}' rel='stylesheet' type='text/css' />
		{/if}
		{if version_compare($smarty.const._PS_VERSION_,'1.6.0.7','>=')}
			{if isset($js_defer) && !$js_defer && isset($js_files) && isset($js_def)}
				{$js_def}
				{foreach from=$js_files item=js_uri}
					<script type="text/javascript" src="{$js_uri|escape:'html':'UTF-8'}"></script>
				{/foreach}
			{/if}
		{else}
			{if isset($js_files)}
				{foreach from=$js_files item=js_uri}
					<script type="text/javascript" src="{$js_uri}"></script>
				{/foreach}
			{/if}
		{/if}
		<!--[if IE 8]><script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script><![endif]-->
		{$HOOK_HEADER}
	</head>
	
	<body {if isset($page_name)}id="{$page_name|escape:'html':'UTF-8'}"{/if} {if $content_only}class="content_only"{/if}>
	{if !$content_only}
	
		{if isset($restricted_country_mode) && $restricted_country_mode}
		<div id="restricted-country" class="error bold">
			<p>{l s='You cannot place a new order from your country.'}</p>
		</div>
		{/if}
		
		<!--[if lt IE 8]>
		<div id="update-browser" class="error">
			<div class="ub-container">
				<div class="ub-warning-img">&nbsp;</div>
				<div class="ub-warning-txt">
					<p class="ub-title">{l s='You are using an outdated web browser : Internet Explorer 6/7'}</p>
					<p>{l s='It contains'} <span class="bold">{l s='security flaws'}</span> {l s='and is'} <span class="bold">{l s='not compatible'}</span> {l s='with this website.'}</p>
					<p><a class="ub-link" href="http://browser-update.org/fr/update.html" target="_blank" title="{l s='Learn how to upgrade your web browser'}">{l s='Update your web browser or upgrade to a modern web browser'}</a></p>
				</div>
				<a class="ub-icon firefox" href="http://www.firefox.com" target="_blank" title="{l s='Install Firefox'}">&nbsp;</a>
				<a class="ub-icon ie" href="http://www.browserforthebetter.com/download.html" target="_blank" title="{l s='Install Internet Explorer'}">&nbsp;</a>
				<a class="ub-icon chrome" href="http://www.google.com/chrome" target="_blank" title="{l s='Install Google Chrome'}">&nbsp;</a>
				<a class="ub-icon safari" href="http://www.apple.com/safari/download/" target="_blank" title="{l s='Install Safari'}">&nbsp;</a>
				<a class="ub-icon opera" href="http://www.opera.com/download/" target="_blank" title="{l s='Install Opera'}">&nbsp;</a>
			</div>
		</div>
		<![endif]-->

		<!-- Header -->
		<header>
			{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
				<div id="header_top_banner">
					<div class="container">
						{hook h="displayBanner"}
					</div>
				</div>
				<div id="header_top_nav">
					<div class="container">
						{hook h="displayNav"}
					</div>
				</div>
			{/if}
			<div id="header_container">
				<div id="header" class="container">
					<a id="header_logo" href="{$base_dir_ssl}" title="{$shop_name|escape:'html':'UTF-8'}">
						<img class="logo" src="{if isset($logo_url)}{$logo_url}{else}{$img_ps_dir}logo.jpg{/if}" alt="{$shop_name|escape:'html':'UTF-8'}" />
					</a>
					{$HOOK_TOP}
				</div>
			</div>
		</header>
			
		<section id="page_container">
			<div id="page" class="container">
			
				{if $page_name == 'index' AND isset($HOOK_TOP_COLUMN)}
					<div id="top_column" class="row-fluid">
						{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
							{hook h="displayTopColumn"}
						{/if}
						{$HOOK_TOP_COLUMN}
					</div>
				{/if}
			
				<div id="columns" class="row-fluid">
					{assign var='left_column_size' value=0}{assign var='right_column_size' value=0}
					{if version_compare($smarty.const._PS_VERSION_,'1.6','>=')}
						{if isset($HOOK_LEFT_COLUMN) && $HOOK_LEFT_COLUMN|trim && !$hide_left_column}{$left_column_size=3}{/if}
					{else}
						{if isset($HOOK_LEFT_COLUMN) && $HOOK_LEFT_COLUMN|trim}{$left_column_size=3}{/if}
					{/if}
					<!-- Left -->
					{if !isset($ptm_column) OR isset($ptm_column) AND $ptm_column == 1}
						{if isset($left_column_size) && !empty($left_column_size)}
							<div id="left_column" class="column span3">
								{$HOOK_LEFT_COLUMN}
							</div>
						{/if}
					{/if}

					<!-- Center -->
					<div id="center_column" class="column span{12 - $left_column_size - $right_column_size}">
	{/if}