{*
 *
 * idnovate.com (http://www.idnovate.com)
 *
 * Order Approval
 *
 * This product is licensed for one customer to use on one installation (test stores and multishop included).
 * Site developer has the right to modify this module to suit their needs, but can not redistribute the module in
 * whole or in part. Any other use of this module constitues a violation of the user agreement.
 *
 * NO WARRANTIES OF DATA SAFETY OR MODULE SECURITY
 * ARE EXPRESSED OR IMPLIED. USE THIS MODULE IN ACCORDANCE
 * WITH YOUR MERCHANT AGREEMENT, KNOWING THAT VIOLATIONS OF
 * PCI COMPLIANCY OR A DATA BREACH CAN COST THOUSANDS OF DOLLARS
 * IN FINES AND DAMAGE A STORES REPUTATION. USE AT YOUR OWN RISK.
 *
*}

<style type="text/css">
	.nobootstrap {
		min-width: 0 !important;
		padding: 100px 30px 0 !important;
	}
	.nobootstrap .margin-form {
		font-size: 0.9em !important;
	}

	.company {
		border: 1px solid black;
		background-color: #2A2A2A;
		color: #FFF;
		overflow: hidden;
		padding: 20px;
		margin: 15px 0;
	}
	.company a{
		color: white;
		font-weight: bold;
	}
	.company ul {
		margin: 6px 0 12px;
		padding-left: 40px;
		list-style-type: disc;
	}
	.company ul li {
		color: #FFF;
	}
	.company .logo {
		padding-bottom: 10px;
	}
	#orderapproval select {
		height: 23px;
		vertical-align: middle;
	}
	#orderapproval label {
		clear: both;
	}
</style>

<h2>{$displayName|escape:'htmlall':'UTF-8'} - {l s='Configuration' mod='orderapproval'}</h2>

<div class="company">
	<div class="logo">
		<img src="{$oa_path|escape:'htmlall':'UTF-8'}img/logo_idnovate.png" title="idnovate.com" alt="idnovate.com" />
	</div>
	<div class="content">
		{l s='We offer you free assistance to install and set up the module. If you have any problem you can:' mod='orderapproval'}
		<ul>
			<li>{l s='Contact us through or website' mod='orderapproval'} <a target="_blank" href="http://www.idnovate.com" title="www.idnovate.com">www.idnovate.com</a></li>
			<li>{l s='Send us an email to' mod='orderapproval'} <a href="mailto:info@idnovate.com" title="{l s='Contact idnovate.com' mod='orderapproval'}">info@idnovate.com</a></li>
		</ul>
	</div>
</div>

{if isset($errors) && $errors|@count > 0}
<div class="bootstrap">
	<div class="module_confirmation alert error alert-warning">
		<h4>{l s='There is/are error/s:' mod='orderapproval'}</h4>
		<ol>
			{foreach from=$errors item=error}
				<li>{$error|escape:'htmlall':'UTF-8'}</li>
			{/foreach}
		</ol>
	</div>
</div>
{/if}

{if isset($success) && $success == true}
<div class="bootstrap">
	<div class="module_confirmation conf confirm alert alert-success">{l s='Settings updated' mod='orderapproval'}</div>
</div>
{/if}

<div style="clear: both"></div>

<form action="{$smarty.server.REQUEST_URI|escape:'htmlall':'UTF-8'}" method="post" class="form" id="orderapproval">

	<fieldset>
		<legend>
			<img src="../img/admin/edit.gif" />
			{l s='Module configuration' mod='orderapproval'}
		</legend>

		<label>{l s='Leave order pending when cart total products are higher or equal than' mod='orderapproval'}:</label>
		<div class="margin-form">
			<input type="text" name="limit_products" value="{if isset($smarty.post.limit_products) and $errors|@count > 0}{$smarty.post.limit_products|escape:'htmlall':'UTF-8'}{elseif isset($limit_products)}{$limit_products|escape:'htmlall':'UTF-8'}{/if}" size="35"/>
			<br />
			<input type="checkbox" name="limit_free_products" {if isset($smarty.post.limit_free_products) && $smarty.post.limit_free_products == 1 && $errors|@count > 0}checked{elseif isset($limit_free_products) && $limit_free_products == 1}checked{/if} value="1"/>
			<label style="float: none; font-size: 1.1em;">{l s='Include free products at product limit' mod='orderapproval'}</label>
		</div>

		<label>{l s='Minimum order amount to leave order pending' mod='orderapproval'}:</label>
		<div id="minimum_amount" class="margin-form">
			<input type="text" name="minimum_amount" value="{$minimum_amount|escape:'htmlall':'UTF-8'}" />
			<select name="moneda">
				<option value=""></option>
				{foreach $currencies as $currency}
				<option value="{$currency.iso_code_num}" {if isset($moneda) and $moneda==$currency.iso_code_num}selected{/if}>{$currency.name}</option>
				{/foreach}
			</select>
			<br />
			<span>{l s='Minimum amount includes taxes, discounts and shipping cost.' mod='orderapproval'}</span><br />
			<span>{l s='This payment method will be only shown is order amount is at least as amount introduced.' mod='orderapproval'}</span><br />
			<span>{l s='If you set 0, the module will be shown always.' mod='orderapproval'}</span>
		</div>

		<label>{l s='Order pending status' mod='orderapproval'}:</label>
		<div class="margin-form">
			<table cellpadding="0" cellspacing="0" class="table">
				<thead>
					<tr>
						<th></th>
						<th style="width: 200px;font-weight: bold;">{l s='Status name' mod='orderapproval'}</th>
					</tr>
				</thead>
				<tbody>
					{foreach from=$states item=state}
					<tr style="background-color: {$state.color|escape:'htmlall':'UTF-8'};">
						<td style="text-align:center">
							<input type="radio" name="state_id" {if isset($smarty.post.state_id) && $smarty.post.state_id == $state.id_order_state && $errors|@count > 0}checked{elseif $state.id_order_state == $state_id}checked{/if} value="{$state.id_order_state}"/>
						</td>
						<td style="color:{if Tools::getBrightness($state.color) < 128}white{else}#383838{/if}">{$state.name}</td>
					</tr>
					{/foreach}
				</tbody>
			</table>
			<span>{l s='Order will be left in this status.' mod='orderapproval'}</span>
		</div>

	</fieldset>

	<div style="clear: both;"></div>
	<br />
	<center>
		<input type="submit" name="btnSubmit" value="{l s='Update settings' mod='orderapproval'}" class="button" />
	</center>
	<hr />
</form>