<?php
/**
 *  Please read the terms of the CLUF license attached to this module(cf "licences" folder)
 *
 * @author    Línea Gráfica E.C.E. S.L.
 * @copyright Lineagrafica.es - Línea Gráfica E.C.E. S.L. all rights reserved.
 * @license   https://www.lineagrafica.es/licenses/license_en.pdf https://www.lineagrafica.es/licenses/license_es.pdf https://www.lineagrafica.es/licenses/license_fr.pdf
 */

class LGDropShipping extends Module
{
    protected $error = false;
    public $bootstrap;

    public function __construct()
    {
        $this->name = 'lgdropshipping';
        $this->tab = 'shipping_logistics';
        $this->version = '1.1.6';
        $this->author = 'Línea Gráfica';
        $this->module_key = '1e7232ca14138003f61b0cec10b5442d';

        parent::__construct();
        if (substr_count(_PS_VERSION_, '1.6') > 0) {
            $this->bootstrap = true;
        } else {
            $this->bootstrap = false;
        }
        $this->displayName = $this->l('Dropshipping - Emails to Suppliers and Carriers');
        $this->description = $this->l('Send your dropshipping orders automatically by email to your suppliers and carriers.');
        $this->confirmUninstall = $this->l('Are you sure that you want to uninstall the module?');
    }

    public function install()
    {
        if (parent::install() == false || $this->registerHook('actionOrderStatusPostUpdate') == false) {
            return false;
        }
        // tables
        $query = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'lgdropshipping_supplier` (
				  `id_supplier` int(11) NOT NULL,
				  `contact_supplier` text NOT NULL,
				  `email_supplier` text NOT NULL,
				  `email_supplier2` text NOT NULL,
				  UNIQUE KEY `id_supplier` (`id_supplier`)
				) ENGINE=InnoDB DEFAULT CHARSET=utf8;';
        if (!Db::getInstance()->Execute($query)) {
            return false;
        }
        $query = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'lgdropshipping_carrier` (
				  `id_reference` int(11) NOT NULL,
				  `contact_carrier` text NOT NULL,
				  `email_carrier` text NOT NULL,
				  `email_carrier2` text NOT NULL,
				  UNIQUE KEY `id_reference` (`id_reference`)
				) ENGINE=InnoDB DEFAULT CHARSET=utf8;';
        if (!Db::getInstance()->Execute($query)) {
            return false;
        }
        $query = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'lgdropshipping_order_state` (
				  `id_order_state_supplier` int(11) NOT NULL,
				  `id_order_state_carrier` int(11) NOT NULL,
				  KEY `id_orderstatus_supplier` (`id_order_state_supplier`,`id_order_state_carrier`)
				) ENGINE=InnoDB DEFAULT CHARSET=utf8;';
        if (!Db::getInstance()->Execute($query)) {
            return false;
        }
        $query = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'lgdropshipping_templates` (
				  `supplier_template` text NOT NULL,
				  `carrier_template` text NOT NULL,
				  `supplier_subject` text NOT NULL,
				  `carrier_subject` text NOT NULL
				) ENGINE=InnoDB DEFAULT CHARSET=utf8;';
        if (!Db::getInstance()->Execute($query)) {
            return false;
        }
        $query = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'lgdropshipping_carrier_to_supplier` (
				  `id_reference` int(11) NOT NULL,
				  `id_supplier` int(11) NOT NULL,
				  UNIQUE KEY `id_supplier` (`id_supplier`),
				  KEY `id_reference` (`id_reference`)
				) ENGINE=InnoDB DEFAULT CHARSET=utf8;';
        if (!Db::getInstance()->Execute($query)) {
            return false;
        }
        // main langs, english by default
        $default_lang = $this->context->language->id;
        $lang = Language::getIsoById($default_lang);
        if ($lang == 'en') {
            Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'lgdropshipping_templates VALUES (\''.pSQL('Dear {SUPPLIER_NAME}. Please prepare the order #{ORDER_REF} of {CUSTOMER_NAME} that contains the following items: {PRODUCTS} The package will be sent with the delivery method {CARRIER_NAME} to the following address: {CUSTOMER_ADDRESS} Best regards,').'\', \''.pSQL('Dear {CARRIER_NAME}. Please pick up the order #{ORDER_REF} in the company {SUPPLIER_NAME} located at the following address: {SUPPLIER_ADDRESS} Please send the package to the following address: {CUSTOMER_ADDRESS} Best regards.').'\', \''.pSQL('Dropshipping Notification - Preparation in Progress').'\', \''.pSQL('Dropshipping Notification - Package Pick-Up', 'html').'\')');
        } elseif ($lang == 'fr') {
            Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'lgdropshipping_templates VALUES (\''.pSQL('Cher {SUPPLIER_NAME}. Veuillez préparer s\'il vous plaît la commande #{ORDER_REF} destinée à {CUSTOMER_NAME} contenant les articles suivants : {PRODUCTS} Le colis sera envoyé avec la méthode de livraison {CARRIER_NAME} à l\'adresse suivante : {CUSTOMER_ADDRESS} Cordialement,').'\', \''.pSQL('Cher {CARRIER_NAME}. Veuillez récupérer s\'il vous plaît la commande #{ORDER_REF} dans l\'entreprise {SUPPLIER_NAME} située à l\'adresse suivante : {SUPPLIER_ADDRESS} Merci d\'envoyer le colis à l\'adresse suivante : {CUSTOMER_ADDRESS} Cordialement.').'\', \''.pSQL('Notification de Dropshipping - Commande en Préparation').'\', \''.pSQL('Notification de Dropshipping - Collecte du Colis', 'html').'\')');
        } elseif ($lang == 'es') {
            Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'lgdropshipping_templates VALUES (\''.pSQL('Estimado {SUPPLIER_NAME}. Por favor prepare el pedido #{ORDER_REF} del cliente {CUSTOMER_NAME} que contiene los productos siguientes: {PRODUCTS} Se mandará el paquete mediante el transportista {CARRIER_NAME} a la dirección siguiente: {CUSTOMER_ADDRESS} Un saludo,').'\', \''.pSQL('Estimado {CARRIER_NAME}. Por favor recoge el pedido #{ORDER_REF} en la empresa {SUPPLIER_NAME} ubicada en: {SUPPLIER_ADDRESS} Y mande el paquete a la direccion siguiente: {CUSTOMER_ADDRESS} Un saludo.').'\', \''.pSQL('Aviso de Dropshipping - Preparación de Pedido').'\', \''.pSQL('Aviso de Dropshipping - Recogida de Pedido', 'html').'\')');
        } else {
            Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'lgdropshipping_templates VALUES (\''.pSQL('Dear {SUPPLIER_NAME}. Please prepare the order #{ORDER_REF} of {CUSTOMER_NAME} that contains the following items: {PRODUCTS} The package will be sent with the delivery method {CARRIER_NAME} to the following address: {CUSTOMER_ADDRESS} Best regards,').'\', \''.pSQL('Dear {CARRIER_NAME}. Please pick up the order #{ORDER_REF} in the company {SUPPLIER_NAME} located at the following address: {SUPPLIER_ADDRESS} Please send the package to the following address: {CUSTOMER_ADDRESS} Best regards.').'\', \''.pSQL('Dropshipping Notification - Preparation in Progress').'\', \''.pSQL('Dropshipping Notification - Package Pick-Up', 'html').'\')');
        }
        return true;
    }

    public function uninstall()
    {
        if (parent::uninstall() == false) {
            return false;
        }
        if (!Db::getInstance()->Execute('DROP TABLE IF EXISTS '._DB_PREFIX_.'lgdropshipping_supplier')) {
            return false;
        }
        if (!Db::getInstance()->Execute('DROP TABLE IF EXISTS '._DB_PREFIX_.'lgdropshipping_carrier')) {
            return false;
        }
        if (!Db::getInstance()->Execute('DROP TABLE IF EXISTS '._DB_PREFIX_.'lgdropshipping_order_state')) {
            return false;
        }
        if (!Db::getInstance()->Execute('DROP TABLE IF EXISTS '._DB_PREFIX_.'lgdropshipping_templates')) {
            return false;
        }
        if (!Db::getInstance()->Execute('DROP TABLE IF EXISTS '._DB_PREFIX_.'lgdropshipping_carrier_to_supplier')) {
            return false;
        }
        return true;
    }

    private function getSuppliers()
    {
        $carriers = Db::getInstance()->ExecuteS('SELECT * FROM '._DB_PREFIX_.'lgdropshipping_supplier');
        return $carriers;
    }

    private function getSupplierName($id_supplier)
    {
        return Db::getInstance()->getValue(
            'SELECT name FROM '._DB_PREFIX_.'supplier '.
            'WHERE id_supplier = '.(int)$id_supplier
        );
    }

    private function getCarriers()
    {
        $suppliers = Db::getInstance()->ExecuteS('SELECT * FROM '._DB_PREFIX_.'lgdropshipping_carrier');
        return $suppliers;
    }

    private function getCarrierName($id_reference)
    {
        return Db::getInstance()->getValue(
            'SELECT name FROM '._DB_PREFIX_.'carrier '.
            'WHERE id_reference = '.(int)$id_reference.' '.
            'ORDER BY id_carrier DESC'
        );
    }

    private function getOrderState()
    {
        $order_state = Db::getInstance()->ExecuteS('SELECT * FROM '._DB_PREFIX_.'order_state');
        return $order_state;
    }

    private function getOrderStateName($id_order_state)
    {
        return Db::getInstance()->getValue(
            'SELECT name FROM '._DB_PREFIX_.'order_state_lang '.
            'WHERE id_lang = '.(int)$this->context->language->id.
            '  AND id_order_state = '.(int)$id_order_state
        );
    }

    private function getSupplierOrderState()
    {
        return Db::getInstance()->getValue(
            'SELECT id_order_state_supplier '.
            'FROM '._DB_PREFIX_.'lgdropshipping_order_state'
        );
    }

    private function getCarrierOrderState()
    {
        return Db::getInstance()->getValue(
            'SELECT id_order_state_carrier '.
            'FROM '._DB_PREFIX_.'lgdropshipping_order_state'
        );
    }

    private function getSupplierSubject()
    {
        return Db::getInstance()->getValue('SELECT supplier_subject FROM '._DB_PREFIX_.'lgdropshipping_templates');
    }

    private function getSupplierTemplate()
    {
        return Db::getInstance()->getValue('SELECT supplier_template FROM '._DB_PREFIX_.'lgdropshipping_templates');
    }

    private function getCarrierSubject()
    {
        return Db::getInstance()->getValue('SELECT carrier_subject FROM '._DB_PREFIX_.'lgdropshipping_templates');
    }

    private function getCarrierTemplate()
    {
        return Db::getInstance()->getValue('SELECT carrier_template FROM '._DB_PREFIX_.'lgdropshipping_templates');
    }

    private function getCarrierSupplier($id_supplier)
    {
        return Db::getInstance()->getValue(
            'SELECT id_reference FROM '._DB_PREFIX_.'lgdropshipping_carrier_to_supplier '.
            'WHERE id_supplier = '.(int)$id_supplier
        );
    }

    private function getSupplierContact($id_supplier)
    {
        return Db::getInstance()->getValue(
            'SELECT contact_supplier FROM '._DB_PREFIX_.'lgdropshipping_supplier '.
            'WHERE id_supplier = '.(int)$id_supplier
        );
    }

    private function getSupplierEmail($id_supplier)
    {
        return Db::getInstance()->getValue(
            'SELECT email_supplier FROM '._DB_PREFIX_.'lgdropshipping_supplier '.
            'WHERE id_supplier = '.(int)$id_supplier
        );
    }
    private function getSupplierEmail2($id_supplier)
    {
        return Db::getInstance()->getValue(
            'SELECT email_supplier2 FROM '._DB_PREFIX_.'lgdropshipping_supplier '.
            'WHERE id_supplier = '.(int)$id_supplier
        );
    }

    private function getCarrierContact($id_reference)
    {
        return Db::getInstance()->getValue(
            'SELECT contact_carrier FROM '._DB_PREFIX_.'lgdropshipping_carrier '.
            'WHERE id_reference = '.(int)$id_reference
        );
    }

    private function getCarrierEmail($id_reference)
    {
        return Db::getInstance()->getValue(
            'SELECT email_carrier FROM '._DB_PREFIX_.'lgdropshipping_carrier '.
            'WHERE id_reference = '.(int)$id_reference
        );
    }

    private function getCarrierEmail2($id_reference)
    {
        return Db::getInstance()->getValue(
            'SELECT email_carrier2 FROM '._DB_PREFIX_.'lgdropshipping_carrier '.
            'WHERE id_reference = '.(int)$id_reference
        );
    }

    private function formatBootstrap($text)
    {
        $text = str_replace('<fieldset>', '<div class="panel">', $text);
        $text = str_replace(
            '<fieldset style="background:#DFF2BF;color:#4F8A10;border:1px solid #4F8A10;">',
            '<div class="panel"  style="background:#DFF2BF;color:#4F8A10;border:1px solid #4F8A10;">',
            $text
        );
        $text = str_replace('</fieldset>', '</div>', $text);
        $text = str_replace('<legend>', '<h3>', $text);
        $text = str_replace('</legend>', '</h3>', $text);
        return $text;
    }

    private function getP()
    {
        $default_lang = $this->context->language->id;
        $lang = Language::getIsoById($default_lang);
        $pl = array('es', 'fr');
        if (!in_array($lang, $pl)) {
            $lang = 'en';
        }

        $this->context->controller->addCSS(_MODULE_DIR_.$this->name.'/views/css/publi/style.css');
        $base = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') ?
            'https://'.$this->context->shop->domain_ssl :
            'http://'.$this->context->shop->domain);
        $uri = $base.$this->context->shop->getBaseURI();
        $path = _PS_MODULE_DIR_.$this->name.DIRECTORY_SEPARATOR
            .'views'.DIRECTORY_SEPARATOR.'publi'.DIRECTORY_SEPARATOR.$lang.DIRECTORY_SEPARATOR.'index.php';
        $object = Tools::file_get_contents($path);
        $object = str_replace('src="/modules/', 'src="'.$uri.'modules/', $object);

        return $object;
    }

    public function getContent()
    {
        $this->_html = $this->getP().'<h2>'.$this->displayName.'</h2>';
        // añadir proveedores si no existen
        $suppliers = Db::getInstance()->ExecuteS('SELECT * FROM '._DB_PREFIX_.'supplier');
        foreach ($suppliers as $supplier) {
            if (
                !Db::getInstance()->ExecuteS(
                    'SELECT * FROM '._DB_PREFIX_.'lgdropshipping_supplier '.
                    'WHERE id_supplier = '.$supplier['id_supplier']
                )
            ) {
                Db::getInstance()->Execute(
                    'INSERT INTO '._DB_PREFIX_.'lgdropshipping_supplier '.
                    'VALUES ('.pSQL($supplier['id_supplier']).', \'\', \'\', \'\')'
                );
            }
        }
        // añadir transportistas si no existen
        $carriers = Db::getInstance()->ExecuteS('SELECT DISTINCT(id_reference) FROM '._DB_PREFIX_.'carrier');
        foreach ($carriers as $carrier) {
            if (
                !Db::getInstance()->ExecuteS(
                    'SELECT * FROM '._DB_PREFIX_.'lgdropshipping_carrier '.
                    'WHERE id_reference = '.$carrier['id_reference']
                )
            ) {
                Db::getInstance()->Execute(
                    'INSERT INTO '._DB_PREFIX_.'lgdropshipping_carrier '.
                    'VALUES ('.pSQL($carrier['id_reference']).', \'\', \'\', \'\')'
                );
            }
        }
        // asignamos estados de pedido si no existe
        if (!Db::getInstance()->ExecuteS('SELECT * FROM '._DB_PREFIX_.'lgdropshipping_order_state')) {
            $order_state = Db::getInstance()->getValue('SELECT id_order_state FROM '._DB_PREFIX_.'order_state WHERE paid = 1');
            Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'lgdropshipping_order_state VALUES ('.pSQL($order_state).', '.pSQL($order_state).')');
        }
        // actualizar proveedores
        if (Tools::isSubmit('updateSupplier')) {
            foreach ($this->getSuppliers() as $supplier) {
                Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'lgdropshipping_supplier SET contact_supplier = \''.pSQL(Tools::getValue('scontact'.$supplier['id_supplier'])).'\', email_supplier = \''.pSQL(Tools::getValue('semail'.$supplier['id_supplier'])).'\', email_supplier2 = \''.pSQL(Tools::getValue('semail2'.$supplier['id_supplier'])).'\' WHERE id_supplier = '.$supplier['id_supplier']);
            }
            $this->_html .= $this->displayConfirmation($this->l('The suppliers have been successfully updated'));
        }
        // actualizar transportistas
        if (Tools::isSubmit('updateCarrier')) {
            foreach ($this->getCarriers() as $carrier) {
                Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'lgdropshipping_carrier SET contact_carrier = \''.pSQL(Tools::getValue('ccontact'.$carrier['id_reference'])).'\', email_carrier = \''.pSQL(Tools::getValue('cemail'.$carrier['id_reference'])).'\', email_carrier2 = \''.pSQL(Tools::getValue('cemail2'.$carrier['id_reference'])).'\' WHERE id_reference = '.$carrier['id_reference']);
            }
            $this->_html .= $this->displayConfirmation($this->l('The carriers have been successfully updated'));
        }
        // actualizar estados de pedido
        if (Tools::isSubmit('updateOrderState')) {
            Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'lgdropshipping_order_state SET id_order_state_supplier = '.pSQL(Tools::getValue('order_state_supplier')).', id_order_state_carrier = '.pSQL(Tools::getValue('order_state_carrier')).'');
            $this->_html .= $this->displayConfirmation($this->l('The order status have been successfully updated'));
        }
        // actualizar asignaciones de transportistas a proveedores
        if (Tools::isSubmit('updateCarrierSupplier')) {
            Db::getInstance()->Execute('TRUNCATE TABLE '._DB_PREFIX_.'lgdropshipping_carrier_to_supplier');
            foreach ($this->getSuppliers() as $supplier) {
                Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'lgdropshipping_carrier_to_supplier VALUES ('.pSQL(Tools::getValue('carriersupplier'.$supplier['id_supplier'])).','.pSQL($supplier['id_supplier']).')');
            }
            $this->_html .= $this->displayConfirmation($this->l('The assignments have been successfully updated'));
        }
        // actualizar plantilla de correo
        if (Tools::isSubmit('updateTemplate')) {
            Db::getInstance()->Execute('TRUNCATE TABLE '._DB_PREFIX_.'lgdropshipping_templates');
            Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'lgdropshipping_templates VALUES (\''.pSQL(Tools::getValue('supplier_template')).'\', \''.pSQL(Tools::getValue('carrier_template')).'\', \''.pSQL(Tools::getValue('supplier_subject')).'\', \''.pSQL(Tools::getValue('carrier_subject')).'\')');
            $this->_html .= $this->displayConfirmation($this->l('The email templates have been successfully updated'));
        }
        // actualizar correo copias
        if (Tools::isSubmit('updateEmail')) {
            Configuration::updateValue('PS_LGDROPSHIPPING_EMAIL', Tools::getValue('emailcp'));
        }

        // actualizar documents
        if (Tools::isSubmit('updateDocuments')) {
            $carriers = Tools::getValue('documents_carrier', array());
            $suppliers = Tools::getValue('documents_supplier', array());
            Configuration::updateValue('PS_LGDROPSHIPPING_DOCS_CARRIER', serialize($carriers));
            Configuration::updateValue('PS_LGDROPSHIPPING_DOCS_SUPPLIER', serialize($suppliers));
        }

        $carriers_docs = unserialize(Configuration::get('PS_LGDROPSHIPPING_DOCS_CARRIER'));
        $suppliers_docs = unserialize(Configuration::get('PS_LGDROPSHIPPING_DOCS_SUPPLIER'));

        // estados de pedido
        $this->_html .= '	<form method="post" action="'.$_SERVER['REQUEST_URI'].'">
								<br><fieldset>
									<legend>'.$this->l('Send dropshipping emails').' <a href="../modules/'.$this->name.'/readme/readme_'.$this->l('en').'.pdf#page=4" target="_blank"><img src="../modules/'.$this->name.'/views/img/info.png"></a></legend>
									<table class="table" width="100%">
										<tr>
											<th>'.$this->l('Send supplier emails when the order status changes to:').'</th>
											<th></th>
											<th>'.$this->l('Send carrier emails when the order status changes to:').'</th>
										</tr>
										<tr>
											<td>
												<select name="order_state_supplier">';
        foreach ($this->getOrderState() as $order_state) {
            $this->_html .= '					<option value="'.$order_state['id_order_state'].'"';
            if ($order_state['id_order_state'] == $this->getSupplierOrderState()) {
                $this->_html .= ' selected';
            }
            $this->_html .= '>'.$this->getOrderStateName($order_state['id_order_state']).'</option>';
        }
        $this->_html .= '					</select>
											</td>
											<td></td>
											<td>
												<select name="order_state_carrier">';
        foreach ($this->getOrderState() as $order_state) {
            $this->_html .= '					<option value="'.$order_state['id_order_state'].'"';
            if ($order_state['id_order_state'] == $this->getCarrierOrderState()) {
                $this->_html .= ' selected';
            }
            $this->_html .= '>'.$this->getOrderStateName($order_state['id_order_state']).'</option>';
        }
        $this->_html .= '					</select>
											</td>
										</tr>
										<tr>
											<td colspan="3" style="color:#4b9f0e;font-weight:bold;">'.$this->l('To send orders to suppliers and carriers, you must go to the menu "Orders" → "Orders", change the order status and choose the same status as above.').'</td>
										</tr>
										<tr>
											<td colspan="3" style="color:#4b9f0e;font-weight:bold;">'.$this->l('When the order status changes and is the same as above, the module will automatically send the emails to the corresponding suppliers and carriers.').'</td>
										</tr>
										<tr>
									</table><br>
									<button class="button btn btn-default" type="submit" name="updateOrderState" ><i class="process-icon-save"></i>'.$this->l('Save').'</button>
								</fieldset>
								</form><br>';
        // copia email
        $this->_html .= '	<br><fieldset>
									<legend>'.$this->l('Receive copies of the emails').' <a href="../modules/'.$this->name.'/readme/readme_'.$this->l('en').'.pdf#page=12" target="_blank"><img src="../modules/'.$this->name.'/views/img/info.png"></a></legend>
									<form method="post" action="'.$_SERVER['REQUEST_URI'].'">
									<label for="emailcp">'.$this->l('Your email address:').'</label>
									<input type="text" name="emailcp" value="'.Configuration::get('PS_LGDROPSHIPPING_EMAIL').'"><br>
									<button class="button btn btn-default" type="submit" name="updateEmail" ><i class="process-icon-save"></i>'.$this->l('Save').'</button>
									</form>
								</fieldset><br><br>';
        // proveedores
        $this->_html .= '	<form method="post" action="'.$_SERVER['REQUEST_URI'].'">
								<fieldset>
									<legend>'.$this->l('Configuration of suppliers').' <a href="../modules/'.$this->name.'/readme/readme_'.$this->l('en').'.pdf#page=5" target="_blank"><img src="../modules/'.$this->name.'/views/img/info.png"></a></legend>
									<table class="table" width="100%">
										<tr>
											<th>ID</th>
											<th>'.$this->l('Supplier').'</th>
											<th>'.$this->l('Variable {SUPPLIER_NAME}:').'</th>
											<th>'.$this->l('Supplier email 1 (required):').'</th>
											<th>'.$this->l('Supplier email 2 (optional):').'</th>
										</tr>';
        $suppliers = $this->getSuppliers();
        foreach ($suppliers as $supplier) {
            $this->_html .= '		<tr>
											<td>'.$supplier['id_supplier'].'</td>
											<td>'.$this->getSupplierName($supplier['id_supplier']).'</td>
											<td><input type="text" name="scontact'.$supplier['id_supplier'].'" value="'.$supplier['contact_supplier'].'" style="width:300px;"></td>
											<td><input type="text" name="semail'.$supplier['id_supplier'].'" value="'.$supplier['email_supplier'].'"></td>
											<td><input type="text" name="semail2'.$supplier['id_supplier'].'" value="'.$supplier['email_supplier2'].'"></td>
										</tr>';
        }
        $this->_html .= '			<tr>
											<td colspan="4" ><br><button class="button btn btn-default" type="submit" name="updateSupplier" ><i class="process-icon-save"></i>'.$this->l('Save').'</button></td>
										</tr>
									</table>
								</fieldset>
								</form><br>';
        // transportistas
        $this->_html .= '	<form method="post" action="'.$_SERVER['REQUEST_URI'].'">
								<br><fieldset>
									<legend>'.$this->l('Configuration of carriers').' <a href="../modules/'.$this->name.'/readme/readme_'.$this->l('en').'.pdf#page=6" target="_blank"><img src="../modules/'.$this->name.'/views/img/info.png"></a></legend>
									<table class="table" width="100%">
										<tr>
											<th>ID</th>
											<th>'.$this->l('Carrier').'</th>
											<th>'.$this->l('Variable {CARRIER_NAME}:').'</th>
											<th>'.$this->l('Carrier email 1 (required):').'</th>
											<th>'.$this->l('Carrier email 2 (optional):').'</th>
										</tr>';
        foreach ($this->getCarriers() as $carrier) {
            $this->_html .= '		<tr>
											<td>'.$carrier['id_reference'].'</td>
											<td>'.$this->getCarrierName($carrier['id_reference']).'</td>
											<td><input type="text" name="ccontact'.$carrier['id_reference'].'" value="'.$carrier['contact_carrier'].'" style="width:300px;"></td>
											<td><input type="text" name="cemail'.$carrier['id_reference'].'" value="'.$carrier['email_carrier'].'"></td>
											<td><input type="text" name="cemail2'.$carrier['id_reference'].'" value="'.$carrier['email_carrier2'].'"></td>
										</tr>';
        }
        $this->_html .= '			<tr>
											<td colspan="4" ><br><button class="button btn btn-default" type="submit" name="updateCarrier" ><i class="process-icon-save"></i>'.$this->l('Save').'</button></td>
										</tr>
									</table>
								</fieldset>
								</form><br>';
        // asociar transportistas a fabricantes
        $this->_html .= '	<form method="post" action="'.$_SERVER['REQUEST_URI'].'">
								<br><fieldset>
									<legend>'.$this->l('Assign carriers to suppliers').'  <a href="../modules/'.$this->name.'/readme/readme_'.$this->l('en').'.pdf#page=7" target="_blank"><img src="../modules/'.$this->name.'/views/img/info.png"></a></legend>
									<table class="table" width="100%">
										<tr>
											<th width="50%">'.$this->l('Suppliers').'</th>
											<th width="50%">'.$this->l('Carriers').'</th>
										</tr>';
        foreach ($this->getSuppliers() as $supplier) {
            $this->_html .= '		<tr>
											<td>'.$this->getSupplierName($supplier['id_supplier']).'</td>
											<td>
												<select name="carriersupplier'.$supplier['id_supplier'].'">
													<option value="0">--</option>';
            foreach ($this->getCarriers() as $carrier) {
                $this->_html .= '				<option value="'.$carrier['id_reference'].'"';
                if ($carrier['id_reference'] == $this->getCarrierSupplier($supplier['id_supplier'])) {
                    $this->_html .= ' selected';
                }
                $this->_html .= '>'.$this->getCarrierName($carrier['id_reference']).'</option>';
            }
            $this->_html .= '				</select>
											</td>
										</tr>';
        }
        $this->_html .= '			<tr>
											<td colspan="2" ><br><button class="button btn btn-default" type="submit" name="updateCarrierSupplier" ><i class="process-icon-save"></i>'.$this->l('Save').'</button></td>
										</tr>
									</table>
								</fieldset>
								</form><br>';
        // plantilla de correo
        $this->_html .= '	<form method="post" action="'.$_SERVER['REQUEST_URI'].'">
								<br><fieldset>
									<legend>'.$this->l('Configuration of the email templates').'  <a href="../modules/'.$this->name.'/readme/readme_'.$this->l('en').'.pdf#page=8" target="_blank"><img src="../modules/'.$this->name.'/views/img/info.png"></a></legend>
									<table class="table" width="100%">
										<tr>
											<td>
												<span style="font-weight:bold;">'.$this->l('Supplier email subject:').' </span><input type="text" name="supplier_subject" style="width:98%;height:40px;padding:10px;" value="'.$this->getSupplierSubject().'">
											</td>
											<td>
												<span style="font-weight:bold;">'.$this->l('Carrier email subject:').' </span><input type="text" name="carrier_subject" style="width:98%;height:40px;padding:10px;" value="'.$this->getCarrierSubject().'">
											</td>
										</tr>
										<tr>
											<td>
												<br><span style="font-weight:bold;">'.$this->l('Supplier email content:').' </span><textarea name="supplier_template" style="width:98%;height:180px;padding:10px;">'.$this->getSupplierTemplate().'</textarea>
											</td>
											<td>
												<br><span style="font-weight:bold;">'.$this->l('Carrier email content:').' </span><textarea name="carrier_template" style="width:98%;height:180px;padding:10px;">'.$this->getCarrierTemplate().'</textarea>
											</td>
										</tr>
										</table><br>
										<table class="table" width="100%">
											<tr>
												<th colspan=6 style="text-align:center;">'.$this->l('Available variables (for the 2 templates)').':</th>
											</tr>
											<tr>
												<th>{CARRIER_NAME}</th>
												<td><span style="color:#4b9f0e;font-weight:bold;text-align:right;">*</span>'.$this->l('Carrier contact name').'</td>
												<th>{CUSTOMER_ADDRESS}</th>
												<td>'.$this->l('Delivery address (name, street, zip code, city, region, country)').'</td>
												<th>{CUSTOMER_EMAIL}</th>
												<td>'.$this->l('Customer email address').'</td>
											</tr>
											<tr>
												<th>{CUSTOMER_NAME}</th>
												<td><span style="color:#4b9f0e;font-weight:bold;text-align:right;">*</span>'.$this->l('Customer name').'</td>
												<th>{CUSTOMER_PHONE}</th>
												<td>'.$this->l('Customer phone number(s)').'</td>
												<th>{INVOICE_NUMBER}</th>
												<td><span style="color:#4b9f0e;font-weight:bold;text-align:right;">*</span>'.$this->l('Invoice number').'</td>
											</tr>
											<tr>
												<th>{ORDER_DATE}</th>
												<td><span style="color:#4b9f0e;font-weight:bold;text-align:right;">*</span>'.$this->l('Order date').'</td>
												<th>{ORDER_ID}</th>
												<td><span style="color:#4b9f0e;font-weight:bold;text-align:right;">*</span>'.$this->l('Order ID').'</td>
												<th>{ORDER_INFO}</th>
												<td>'.$this->l('Note written by the customer during the order process').'</td>
											</tr>
											<tr>
												<th>{ORDER_REF}</th>
												<td><span style="color:#4b9f0e;font-weight:bold;text-align:right;">*</span>'.$this->l('Order reference').'</td>
												<th>{PRODUCTS}</th>
												<td>'.$this->l('Products (quantity, name, attributes, reference, link)').'</td>
												<th>{SUPPLIER_ADDRESS}</th>
												<td>'.$this->l('Supplier address (name, street, zip code, city, region, country)').'</td>
											</tr>
											<tr>
												<th>{SUPPLIER_NAME}</th>
												<td><span style="color:#4b9f0e;font-weight:bold;text-align:right;">*</span>'.$this->l('Supplier contact name').'</td>
												<th>{SUPPLIER_PHONE}</th>
												<td>'.$this->l('Supplier phone number(s)').'</td>
                                                <th></th>
												<td></td>
											</tr>
                                            <tr>
												<td colspan=6"><span style="color:#4b9f0e;font-weight:bold;">*'.$this->l('These variables can be used in the email titles').'</span></td>
											</tr>
										</table><br>		
											<button class="button btn btn-default" type="submit" name="updateTemplate" ><i class="process-icon-save"></i>'.$this->l('Save').'</button>
								</fieldset>
								</form><br>';
        //documents
        $this->_html .= '<br><form method="post" action="'.$_SERVER['REQUEST_URI'].'">
				<fieldset>
                        <legend>'.$this->l('Attach documents to the emails').' <a href="../modules/'.$this->name.'/readme/readme_'.$this->l('en').'.pdf#page=11" target="_blank"><img src="../modules/'.$this->name.'/views/img/info.png"></a></legend>
            <table class="table" width="100%">
                    <tr>
                        <th colspan="3">
                            <p style="text-align:center;">'.$this->l('Document for suppliers:').'</p>
                        </th>
						<th width="100px;"></th>
                        <th colspan="3">
                            <p style="text-align:center;">'.$this->l('Document for carriers:').'</p>
                        </th>
                    </tr>
                    <tr>
                        <td>
							<input type="radio" '.(is_array($suppliers_docs) && in_array('none', $suppliers_docs) ? ' checked="checked" ' : '').' id="none" name="documents_supplier[]" value="none" >&nbsp;<img src="../modules/'.$this->name.'/views/img/icon1.png" width="15px" alt="none"/> <b>'.$this->l('None').'</b>
					    </td>
                        <td>
						    <input type="radio" '.(is_array($suppliers_docs) && in_array('delivery_slip', $suppliers_docs) ? ' checked="checked" ' : '').' id="albaran_supplier" name="documents_supplier[]" value="delivery_slip">&nbsp;<img src="../modules/'.$this->name.'/views/img/icon2.png" width="15px" alt="delivery slip"/> <b>'.$this->l('Delivery slip').'</b>
						</td>
                        <td>
						    <input type="radio" '.(is_array($suppliers_docs) && in_array('invoice', $suppliers_docs) ? ' checked="checked" ' : '').' id="invoice_supplier" name="documents_supplier[]"  value="invoice">&nbsp;<img src="../modules/'.$this->name.'/views/img/icon3.png" width="15px" alt="invoice"/> <b>'.$this->l('Invoice').'</b>
						</td>
						<td></td>
	                    <td>
						    <input id="none" '.(is_array($carriers_docs) && in_array('none', $carriers_docs) ? ' checked="checked" ' : '').' type="radio" name="documents_carrier[]" value="none">&nbsp;<img src="../modules/'.$this->name.'/views/img/icon1.png" width="15px" alt="none"/> <b>'.$this->l('None').'</b>
						</td>
	                    <td>
						    <input id="albaran_carrier" '.(is_array($carriers_docs) && in_array('delivery_slip', $carriers_docs) ? ' checked="checked" ' : '').' type="radio" name="documents_carrier[]" value="delivery_slip">&nbsp;<img src="../modules/'.$this->name.'/views/img/icon2.png" width="15px" alt="delivery slip"/> <b>'.$this->l('Delivery slip').'</b>
						</td>
	                    <td>
						    <input id="invoice_carrier"  '.(is_array($carriers_docs) && in_array('invoice', $carriers_docs) ? ' checked="checked" ' : '').' type="radio" name="documents_carrier[]"  value="invoice">&nbsp;<img src="../modules/'.$this->name.'/views/img/icon3.png" width="15px" alt="invoice"/> <b>'.$this->l('Invoice').'</b>
						</td>
                    </tr>
                    <tr>
			</table><br>
							<button class="button btn btn-default" type="submit" name="updateDocuments" ><i class="process-icon-save"></i>'.$this->l('Save').'</button>
				</fieldset></form><br>
			';
        if ($this->bootstrap == true) {
            $this->_html = $this->formatBootstrap($this->_html);
        }
        return $this->_html;
    }

    public function hookactionOrderStatusPostUpdate($params)
    {
        $id_order_state = $params['newOrderStatus']->id;
        if ($this->getSupplierOrderState() == $id_order_state || $this->getCarrierOrderState() == $id_order_state) {
            $id_order = $params['id_order'];
            $id_address_delivery = $params['cart']->id_address_delivery;
            $id_lang = $params['cart']->id_lang;
            // get order products
            $products = Db::getInstance()->ExecuteS('SELECT * FROM '._DB_PREFIX_.'order_detail WHERE id_order = '.(int)$id_order);
            $suppliers = array();
            // get suppliers
            foreach ($products as $product) {
                $id_supplier = Db::getInstance()->getValue('SELECT id_supplier FROM '._DB_PREFIX_.'product WHERE id_product = '.(int)$product['product_id']);

                if ($id_supplier > 0 && !in_array($id_supplier, $suppliers)) {
                    array_push($suppliers, $id_supplier);
                }
            }
            // preparamos el envío de emails
            foreach ($suppliers as $supplier) {
                $id_reference = $this->getCarrierSupplier($supplier);
                $productos = '<br>';
                foreach ($products as $product) {
                    $id_supplier = Db::getInstance()->getValue('SELECT id_supplier FROM '._DB_PREFIX_.'product WHERE id_product = '.(int)$product['product_id']);
                    $prod_link = $this->context->link->getProductLink((int)$product['product_id']);
                    $link_rewrite = Db::getInstance()->getValue('SELECT link_rewrite FROM '._DB_PREFIX_.'product_lang WHERE id_product = '.(int)$product['product_id']);
                    $prod_image = $this->context->link->getImageLink($link_rewrite, (int)$product['product_id']);
                    $supplier_reference = Db::getInstance()->getValue('SELECT product_supplier_reference FROM '._DB_PREFIX_.'product_supplier WHERE id_product_attribute = '.(int)$product['product_attribute_id']);
                    if ($id_supplier == $supplier) {
                        $query = 'SELECT cd.value, cd.index FROM '._DB_PREFIX_.'customized_data cd INNER JOIN '._DB_PREFIX_.'customization c ON c.id_customization = cd.id_customization AND id_cart = '.(int)$params['cart']->id.' AND cd.type = 1 AND c.in_cart = 1 AND c.id_product = '.(int)$product['product_id'].' AND c.id_product_attribute = '.(int)$product['product_attribute_id'];
                        $customized_data = DB::getInstance()->executeS($query);
                        $cust = '';
                        if ($customized_data) {
                            foreach ($customized_data as $data) {
                                $datatitle = Db::getInstance()->getValue('SELECT name FROM '._DB_PREFIX_.'customization_field_lang WHERE id_customization_field = '.(int)$data['index']);
                                $cust .= '<br>'.$datatitle.' '.$data['value'];
                            }
                        }
                        $productos .= '<a href="'.$prod_image.'" target="_blank"><img src="'.$prod_image.'" border="1" height="20" width="20"></a> '.$product['product_quantity'].'x <a href="'.$prod_link.'" target="_blank">'.$product['product_name'].'</a> (ref: '.$product['product_reference'].' '.$supplier_reference.') '.$cust.'<br>';
                    }
                }
                // montar y enviar email
                if ($this->getSupplierOrderState() == $id_order_state) {
                    $order_ref = Db::getInstance()->getValue('SELECT reference FROM '._DB_PREFIX_.'orders WHERE id_order = '.(int)$id_order);
                    $invoice_num = Db::getInstance()->getValue('SELECT invoice_number FROM '._DB_PREFIX_.'orders WHERE id_order = '.(int)$id_order);
                    $order_date0 = Db::getInstance()->getValue('SELECT date_add FROM '._DB_PREFIX_.'orders WHERE id_order = '.(int)$id_order);
                    $order_date = date('d-m-Y', strtotime($order_date0));
                    $contact = $this->getSupplierContact($supplier);
                    $email = $this->getSupplierEmail($supplier);
                    $email2 = $this->getSupplierEmail2($supplier);
                    $address_delivery = '<br>';
                    $del_address = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'address WHERE id_address = '.(int)$id_address_delivery);
                    $customer_email = Db::getInstance()->getValue('SELECT email FROM '._DB_PREFIX_.'customer WHERE id_customer = '.(int)$del_address['id_customer']);
                    $customer_email2 = '<a href="mailto:'.$customer_email.'">'.$customer_email.'</a>';
                    $customer_thread = Db::getInstance()->getValue('SELECT id_customer_thread FROM '._DB_PREFIX_.'customer_thread WHERE id_order = '.(int)$id_order);
                    $customer_message = Db::getInstance()->getValue('SELECT message FROM '._DB_PREFIX_.'customer_message WHERE id_customer_thread = '.(int)$customer_thread);
                    $del_state = Db::getInstance()->getValue('SELECT name FROM '._DB_PREFIX_.'state WHERE id_state = '.(int)$del_address['id_state']);
                    $del_country = Db::getInstance()->getValue('SELECT name FROM '._DB_PREFIX_.'country_lang WHERE id_country = '.(int)$del_address['id_country'].' AND id_lang = '.(int)$id_lang);
                    $customer_name = $del_address['firstname'].' '.$del_address['lastname'];
                    $address_delivery .= $del_address['firstname'].' '.$del_address['lastname']."\n";
                    if (Tools::strlen($del_address['company']) > 0) {
                        $address_delivery .= $del_address['company']."\n";
                    }
                    $address_delivery .= $del_address['address1']."\n";
                    if (Tools::strlen($del_address['address2']) > 0) {
                        $address_delivery .= $del_address['address2']."\n";
                    }
                    $address_delivery .= $del_address['postcode'].' '.$del_address['city']."\n";
                    if (Tools::strlen($del_state) > 0) {
                        $address_delivery .= $del_state."\n";
                    }
                    $address_delivery .= $del_country."\n";
                    $customer_phone = '';
                    $customer_phone .= $del_address['phone']."\n";
                    if (Tools::strlen($del_address['phone_mobile']) > 0) {
                        $customer_phone .= ' '.$del_address['phone_mobile']."\n";
                    }
                    $supplier_address = '<br>';
                    $sup_address = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'address WHERE id_supplier = '.(int)$id_supplier);
                    $sup_state = Db::getInstance()->getValue('SELECT name FROM '._DB_PREFIX_.'state WHERE id_state = '.(int)$sup_address['id_state']);
                    $sup_country = Db::getInstance()->getValue('SELECT name FROM '._DB_PREFIX_.'country_lang WHERE id_country = '.(int)$sup_address['id_country'].' AND id_lang = '.(int)$id_lang);
                    $supplier_address .= $sup_address['alias']."\n";
                    $supplier_address .= $sup_address['address1']."\n";
                    if (Tools::strlen($sup_address['address2']) > 0) {
                        $supplier_address .= $sup_address['address2']."\n";
                    }
                    $supplier_address .= $sup_address['postcode'].' '.$sup_address['city']."\n";
                    if (Tools::strlen($sup_state) > 0) {
                        $supplier_address .= $sup_state."\n";
                    }
                    $supplier_address .= $sup_country."\n";
                    $supplier_phone = '';
                    $supplier_phone .= $sup_address['phone']."\n";
                    if (Tools::strlen($sup_address['phone_mobile']) > 0) {
                        $supplier_phone .= ' '.$sup_address['phone_mobile']."\n";
                    }
                    // get email template
                    $supplier_template = nl2br(Db::getInstance()->getValue('SELECT supplier_template FROM '._DB_PREFIX_.'lgdropshipping_templates'));
                    $supplier_template = str_replace('{SUPPLIER_NAME}', $this->getSupplierContact($supplier), $supplier_template);
                    $supplier_template = str_replace('{CARRIER_NAME}', $this->getCarrierContact($id_reference), $supplier_template);
                    $supplier_template = str_replace('{ORDER_INFO}', $customer_message, $supplier_template);
                    $supplier_template = str_replace('{CUSTOMER_NAME}', $customer_name, $supplier_template);
                    $supplier_template = str_replace('{ORDER_DATE}', $order_date, $supplier_template);
                    $supplier_template = str_replace('{ORDER_ID}', $id_order, $supplier_template);
                    $supplier_template = str_replace('{ORDER_REF}', $order_ref, $supplier_template);
                    $supplier_template = str_replace('{INVOICE_NUMBER}', $invoice_num, $supplier_template);
                    $supplier_template = str_replace('{PRODUCTS}', $productos, $supplier_template);
                    $supplier_template = str_replace('{CUSTOMER_ADDRESS}', nl2br($address_delivery), $supplier_template);
                    $supplier_template = str_replace('{SUPPLIER_ADDRESS}', nl2br($supplier_address), $supplier_template);
                    $supplier_template = str_replace('{CUSTOMER_EMAIL}', $customer_email2, $supplier_template);
                    $supplier_template = str_replace('{CUSTOMER_PHONE}', $customer_phone, $supplier_template);
                    $supplier_template = str_replace('{SUPPLIER_PHONE}', $supplier_phone, $supplier_template);
                    $data = array('{SUPPLIER_TEMPLATE}' => $supplier_template);
                    $supplier_title = nl2br(Db::getInstance()->getValue('SELECT supplier_subject FROM '._DB_PREFIX_.'lgdropshipping_templates'));
                    $supplier_title = str_replace('{SUPPLIER_NAME}', $this->getSupplierContact($supplier), $supplier_title);
                    $supplier_title = str_replace('{CARRIER_NAME}', $this->getCarrierContact($id_reference), $supplier_title);
                    $supplier_title = str_replace('{CUSTOMER_NAME}', $customer_name, $supplier_title);
                    $supplier_title = str_replace('{ORDER_DATE}', $order_date, $supplier_title);
                    $supplier_title = str_replace('{ORDER_ID}', $id_order, $supplier_title);
                    $supplier_title = str_replace('{ORDER_REF}', $order_ref, $supplier_title);
                    $supplier_title = str_replace('{INVOICE_NUMBER}', $invoice_num, $supplier_title);
                    $suppliers_docs = unserialize(Configuration::get('PS_LGDROPSHIPPING_DOCS_SUPPLIER'));
                    $attachments = array();
                    $order = new Order($id_order);
                    if (is_array($suppliers_docs) && in_array('delivery_slip', $suppliers_docs)) {
                        $pdf = new PDF($order->getDeliverySlipsCollection(), PDF::TEMPLATE_DELIVERY_SLIP, $this->context->smarty);
                        $file_attachement = array();
                        $file_attachement['content'] = $pdf->render(false);
                        $file_attachement['name'] = Configuration::get('PS_DELIVERY_PREFIX', (int)$order->id_lang, null, $order->id_shop).sprintf('%06d', $order->delivery_number).'.pdf';
                        $file_attachement['mime'] = 'application/pdf';
                        $attachments[] = $file_attachement;
                    }
                    if (is_array($suppliers_docs) && in_array('invoice', $suppliers_docs) && (int)Configuration::get('PS_INVOICE') && $order->invoice_number
                    ) {
                        $pdf = new PDF($order->getInvoicesCollection(), PDF::TEMPLATE_INVOICE, $this->context->smarty);
                        $file_attachement = array();
                        $file_attachement['content'] = $pdf->render(false);
                        $file_attachement['name'] = Configuration::get('PS_INVOICE_PREFIX', (int)$order->id_lang, null, $order->id_shop).sprintf('%06d', $order->invoice_number).'.pdf';
                        $file_attachement['mime'] = 'application/pdf';
                        $attachments[] = $file_attachement;
                    }
                    // send supplier email 1
                    if ($email != false) {
                        Mail::Send(
                            (int)$this->context->language->id,
                            'suppliermail',
                            $supplier_title,
                            $data,
                            $email,
                            $contact,
                            null,
                            (string)Configuration::get('PS_SHOP_NAME'),
                            $attachments,
                            null,
                            dirname(__FILE__).'/mails/',
                            '',
                            $this->context->shop->id
                        );
                    }
                    // send supplier email 2
                    if ($email2 != false) {
                        Mail::Send(
                            (int)$this->context->language->id,
                            'suppliermail',
                            $supplier_title,
                            $data,
                            $email2,
                            $contact,
                            null,
                            (string)Configuration::get('PS_SHOP_NAME'),
                            $attachments,
                            null,
                            dirname(__FILE__).'/mails/',
                            '',
                            $this->context->shop->id
                        );
                    }
                    // send supplier email copy
                    if ($email != false or $email2 != false) {
                        if (Tools::strlen(Configuration::get('PS_LGDROPSHIPPING_EMAIL')) > 5) {
                            $supplier_titleC = $supplier_title . " " . $this->l('(copy)');
                            Mail::Send(
                                (int)$this->context->language->id,
                                'suppliermail',
                                $supplier_titleC,
                                $data,
                                Configuration::get('PS_LGDROPSHIPPING_EMAIL'),
                                $contact,
                                null,
                                (string)Configuration::get('PS_SHOP_NAME'),
                                $attachments,
                                null,
                                dirname(__FILE__).'/mails/',
                                '',
                                $this->context->shop->id
                            );
                        }
                    }
                }
                if ($this->getCarrierOrderState() == $id_order_state) {
                    $id_reference = $this->getCarrierSupplier($supplier);
                    $order_ref = Db::getInstance()->getValue('SELECT reference FROM '._DB_PREFIX_.'orders WHERE id_order = '.(int)$id_order);
                    $invoice_num = Db::getInstance()->getValue('SELECT invoice_number FROM '._DB_PREFIX_.'orders WHERE id_order = '.(int)$id_order);
                    $order_date0 = Db::getInstance()->getValue('SELECT date_add FROM '._DB_PREFIX_.'orders WHERE id_order = '.(int)$id_order);
                    $order_date = date('d-m-Y', strtotime($order_date0));
                    $contact = $this->getCarrierContact($id_reference);
                    $email = $this->getCarrierEmail($id_reference);
                    $email2 = $this->getCarrierEmail2($id_reference);
                    $address_delivery = '<br>';
                    $del_address = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'address WHERE id_address = '.(int)$id_address_delivery);
                    $customer_email = Db::getInstance()->getValue('SELECT email FROM '._DB_PREFIX_.'customer WHERE id_customer = '.(int)$del_address['id_customer']);
                    $customer_email2 = '<a href="mailto:'.$customer_email.'">'.$customer_email.'</a>';
                    $customer_thread = Db::getInstance()->getValue('SELECT id_customer_thread FROM '._DB_PREFIX_.'customer_thread WHERE id_order = '.(int)$id_order);
                    $customer_message = Db::getInstance()->getValue('SELECT message FROM '._DB_PREFIX_.'customer_message WHERE id_customer_thread = '.(int)$customer_thread);
                    $del_state = Db::getInstance()->getValue('SELECT name FROM '._DB_PREFIX_.'state WHERE id_state = '.(int)$del_address['id_state']);
                    $del_country = Db::getInstance()->getValue('SELECT name FROM '._DB_PREFIX_.'country_lang WHERE id_country = '.(int)$del_address['id_country'].' AND id_lang = '.(int)$id_lang);
                    $customer_name2 = $del_address['firstname'].' '.$del_address['lastname'];
                    $address_delivery .= $del_address['firstname'].' '.$del_address['lastname']."\n";
                    if (Tools::strlen($del_address['company']) > 0) {
                        $address_delivery .= $del_address['company']."\n";
                    }
                    $address_delivery .= $del_address['address1']."\n";
                    if (Tools::strlen($del_address['address2']) > 0) {
                        $address_delivery .= $del_address['address2']."\n";
                    }
                    $address_delivery .= $del_address['postcode'].' '.$del_address['city']."\n";
                    if (Tools::strlen($del_state) > 0) {
                        $address_delivery .= $del_state."\n";
                    }
                    $address_delivery .= $del_country."\n";
                    $customer_phone = '';
                    $customer_phone .= $del_address['phone']."\n";
                    if (Tools::strlen($del_address['phone_mobile']) > 0) {
                        $customer_phone .= ' '.$del_address['phone_mobile']."\n";
                    }
                    $supplier_address = '<br>';
                    $sup_address = Db::getInstance()->getRow('SELECT * FROM '._DB_PREFIX_.'address WHERE id_supplier = '.(int)$id_supplier);
                    $sup_state = Db::getInstance()->getValue('SELECT name FROM '._DB_PREFIX_.'state WHERE id_state = '.(int)$sup_address['id_state']);
                    $sup_country = Db::getInstance()->getValue('SELECT name FROM '._DB_PREFIX_.'country_lang WHERE id_country = '.(int)$sup_address['id_country'].' AND id_lang = '.(int)$id_lang);
                    $supplier_address .= $sup_address['alias']."\n";
                    $supplier_address .= $sup_address['address1']."\n";
                    if (Tools::strlen($sup_address['address2']) > 0) {
                        $supplier_address .= $sup_address['address2']."\n";
                    }
                    $supplier_address .= $sup_address['postcode'].' '.$sup_address['city']."\n";
                    if (Tools::strlen($del_state) > 0) {
                        $supplier_address .= $del_state."\n";
                    }
                    $supplier_address .= $sup_country."\n";
                    $supplier_phone = '';
                    $supplier_phone .= $sup_address['phone']."\n";
                    if (Tools::strlen($sup_address['phone_mobile']) > 0) {
                        $supplier_phone .= ' '.$sup_address['phone_mobile']."\n";
                    }
                    // get email template
                    $carrier_template = nl2br(Db::getInstance()->getValue('SELECT carrier_template FROM '._DB_PREFIX_.'lgdropshipping_templates'));
                    $carrier_template = str_replace('{SUPPLIER_NAME}', $this->getSupplierContact($supplier), $carrier_template);
                    $carrier_template = str_replace('{CARRIER_NAME}', $this->getCarrierContact($id_reference), $carrier_template);
                    $carrier_template = str_replace('{ORDER_INFO}', $customer_message, $carrier_template);
                    $carrier_template = str_replace('{CUSTOMER_NAME}', $customer_name2, $carrier_template);
                    $carrier_template = str_replace('{ORDER_DATE}', $order_date, $carrier_template);
                    $carrier_template = str_replace('{ORDER_ID}', $id_order, $carrier_template);
                    $carrier_template = str_replace('{ORDER_REF}', $order_ref, $carrier_template);
                    $carrier_template = str_replace('{INVOICE_NUMBER}', $invoice_num, $carrier_template);
                    $carrier_template = str_replace('{PRODUCTS}', $productos, $carrier_template);
                    $carrier_template = str_replace('{CUSTOMER_ADDRESS}', nl2br($address_delivery), $carrier_template);
                    $carrier_template = str_replace('{SUPPLIER_ADDRESS}', nl2br($supplier_address), $carrier_template);
                    $carrier_template = str_replace('{CUSTOMER_EMAIL}', $customer_email2, $carrier_template);
                    $carrier_template = str_replace('{CUSTOMER_PHONE}', $customer_phone, $carrier_template);
                    $carrier_template = str_replace('{SUPPLIER_PHONE}', $supplier_phone, $carrier_template);
                    $data = array('{CARRIER_TEMPLATE}' => $carrier_template);
                    $carrier_title = nl2br(Db::getInstance()->getValue('SELECT carrier_subject FROM '._DB_PREFIX_.'lgdropshipping_templates'));
                    $carrier_title = str_replace('{SUPPLIER_NAME}', $this->getSupplierContact($supplier), $carrier_title);
                    $carrier_title = str_replace('{CARRIER_NAME}', $this->getCarrierContact($id_reference), $carrier_title);
                    $carrier_title = str_replace('{CUSTOMER_NAME}', $customer_name2, $carrier_title);
                    $carrier_title = str_replace('{ORDER_DATE}', $order_date, $carrier_title);
                    $carrier_title = str_replace('{ORDER_ID}', $id_order, $carrier_title);
                    $carrier_title = str_replace('{ORDER_REF}', $order_ref, $carrier_title);
                    $carrier_title = str_replace('{INVOICE_NUMBER}', $invoice_num, $carrier_title);
                    $carriers_docs = unserialize(Configuration::get('PS_LGDROPSHIPPING_DOCS_CARRIER'));
                    $attachments = array();
                    $order = new Order($id_order);
                    if (is_array($carriers_docs) && in_array('delivery_slip', $carriers_docs)) {
                        $pdf = new PDF($order->getDeliverySlipsCollection(), PDF::TEMPLATE_DELIVERY_SLIP, $this->context->smarty);
                        $file_attachement = array();
                        $file_attachement['content'] = $pdf->render(false);
                        $file_attachement['name'] = Configuration::get('PS_DELIVERY_PREFIX', (int)$order->id_lang, null, $order->id_shop).sprintf('%06d', $order->delivery_number).'.pdf';
                        $file_attachement['mime'] = 'application/pdf';
                        $attachments[] = $file_attachement;
                    }
                    if (is_array($carriers_docs) && in_array('invoice', $carriers_docs) && (int)Configuration::get('PS_INVOICE') && $order->invoice_number
                    ) {
                        $pdf = new PDF($order->getInvoicesCollection(), PDF::TEMPLATE_INVOICE, $this->context->smarty);
                        $file_attachement = array();
                        $file_attachement['content'] = $pdf->render(false);
                        $file_attachement['name'] = Configuration::get('PS_INVOICE_PREFIX', (int)$order->id_lang, null, $order->id_shop).sprintf('%06d', $order->invoice_number).'.pdf';
                        $file_attachement['mime'] = 'application/pdf';
                        $attachments[] = $file_attachement;
                    }
                    // send carrier email 1
                    if ($email != false) {
                        Mail::Send(
                            (int)$this->context->language->id,
                            'carriermail',
                            $carrier_title,
                            $data,
                            $email,
                            $contact,
                            (string)Configuration::get('PS_SHOP_EMAIL'),
                            (string)Configuration::get('PS_SHOP_NAME'),
                            $attachments,
                            null,
                            dirname(__FILE__).'/mails/'
                        );
                    }
                    // send carrier email 2
                    if ($email2 != false) {
                        Mail::Send(
                            (int)$this->context->language->id,
                            'carriermail',
                            $carrier_title,
                            $data,
                            $email2,
                            $contact,
                            (string)Configuration::get('PS_SHOP_EMAIL'),
                            (string)Configuration::get('PS_SHOP_NAME'),
                            $attachments,
                            null,
                            dirname(__FILE__).'/mails/'
                        );
                    }
                    // send carrier email copy
                    if ($email != false or $email2 != false) {
                        if (Tools::strlen(Configuration::get('PS_LGDROPSHIPPING_EMAIL')) > 5) {
                            $carrier_titleC = $carrier_title . " " . $this->l('(copy)');
                            Mail::Send(
                                (int)$this->context->language->id,
                                'carriermail',
                                $carrier_titleC,
                                $data,
                                Configuration::get('PS_LGDROPSHIPPING_EMAIL'),
                                $contact,
                                (string)Configuration::get('PS_SHOP_EMAIL'),
                                (string)Configuration::get('PS_SHOP_NAME'),
                                $attachments,
                                null,
                                dirname(__FILE__).'/mails/'
                            );
                        }
                    }
                }
            }
        }
    }
}
