<?php
/**
 * Author: egrove systems
 * Created by: EGS 140
 * Updated by: EGS 161
 * Updated on: 11/07/2012
 **/
class eGrPayFlowPro extends PaymentModule
{
	protected	$_partner;
	protected	$_apiUser;
	protected	$_apiPassword;
	protected	$_apiVendor;
	protected	$_sandbox;
	protected	$_egrcurrency;
	protected       $_authCapture;


	public function __construct()
	{
		$this->name = 'egrpayflowpro';
		if((str_replace(".","",substr(_PS_VERSION_,0,3))*1)>13) $this->tab = 'payments_gateways';
		else $this->tab = 'Payment';
        $this->version = '1.0';
		$this->author = 'eGrove Systems';

		parent::__construct();

		$this->displayName = $this->l('PayFlow Pro');
		$this->description = $this->l('Accepts payments by PayFlow Pro');
		$this->confirmUninstall = $this->l('Are you sure you want to delete your details ?');

		$this->_init();
		
	}

	protected function _init()
	{
		$config = Configuration::getMultiple(array('EGR_PAYFLOW_PARTNER', 'EGR_PAYFLOW_SANDBOX', 'EGR_PAYFLOW_USER', 'EGR_PAYFLOW_PASSWORD', 'EGR_PAYFLOW_VENDOR', 'EGR_PAYFLOW_CURRENCY','EGR_AUTH_CAPTURE'));
		
		
		if (isset($config['EGR_PAYFLOW_USER']))
			$this->_apiUser = $config['EGR_PAYFLOW_USER'];
		if (isset($config['EGR_PAYFLOW_PASSWORD']))
			$this->_apiPassword = $config['EGR_PAYFLOW_PASSWORD'];
		if (isset($config['EGR_PAYFLOW_VENDOR']))
			$this->_apiVendor = $config['EGR_PAYFLOW_VENDOR'];
		if (isset($config['EGR_PAYFLOW_PARTNER']))
			$this->_partner = $config['EGR_PAYFLOW_PARTNER'];
			
		
		if (isset($config['EGR_PAYFLOW_SANDBOX']))
			$this->_sandbox = $config['EGR_PAYFLOW_SANDBOX'];
		if (isset($config['EGR_PAYFLOW_CURRENCY']))
			$this->_egrcurrency = $config['EGR_PAYFLOW_CURRENCY'];
		if (isset($config['EGR_AUTH_CAPTURE']))
			$this->_authCapture = $config['EGR_AUTH_CAPTURE'];
			
	}

	public function install()
	{
		Db::getInstance()->Execute
			('
				CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'payflowpro_order` 
				(
				  `id_order` int(10) unsigned NOT NULL auto_increment,
				  `id_transaction` varchar(255) NOT NULL,
				  `transaction_type` varchar(255) NOT NULL,
				  PRIMARY KEY (`id_order`)
				) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
			');

		// Next
		if (!parent::install()
			OR !Configuration::updateValue('EGR_PAYFLOW_PARTNER', 'PayPal')
			OR !Configuration::updateValue('EGR_PAYFLOW_SANDBOX', 1)
			OR !Configuration::updateValue('EGR_PAYFLOW_USER', 'egrovepayflow')
			OR !Configuration::updateValue('EGR_PAYFLOW_PASSWORD', 'admin@123')
			OR !Configuration::updateValue('EGR_PAYFLOW_VENDOR', 'egrovepayflow')
			OR !Configuration::updateValue('EGR_PAYFLOW_CURRENCY', 1)
			OR !Configuration::updateValue('EGR_AUTH_CAPTURE', 'S')
			OR !$this->registerHook('payment')
			OR !$this->registerHook('shoppingCartExtra')
			OR !$this->registerHook('backBeforePayment')
			OR !$this->registerHook('paymentReturn')
		)
			return false;
		return true;
	}

	public function uninstall()
	{
		if (!parent::uninstall()
			OR !Configuration::deleteByName('EGR_PAYFLOW_PARTNER')
			OR !Configuration::deleteByName('EGR_PAYFLOW_SANDBOX')
			OR !Configuration::deleteByName('EGR_PAYFLOW_USER')
			OR !Configuration::deleteByName('EGR_PAYFLOW_PASSWORD')
			OR !Configuration::deleteByName('EGR_PAYFLOW_VENDOR')
			OR !Configuration::deleteByName('EGR_PAYFLOW_CURRENCY')
			OR !Configuration::deleteByName('EGR_AUTH_CAPTURE')
			)
			return false;
		return true;
	}
	
	public function getContent()
	{
		return $this->home();
	}
	
	public function hookPayment($params)
	{
		global $smarty;
		$smarty->assign(array(
		    'this_path' => $this->_path,
		    'this_path_ssl' => (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://') . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8') . __PS_BASE_URI__ . 'modules/' . $this->name . '/'
		));
		if (substr(_PS_VERSION_, 0, 3) === "1.5" )
				$smarty->assign('this_version', "1.5");
				if (substr(_PS_VERSION_, 0, 3) === "1.4" )
				$smarty->assign('this_version', "1.4");
		return $this->display(__FILE__, 'payment.tpl');
	}
	
	public function hookPaymentReturn($params)
	{
		if (!$this->active)
			return;
		return $this->display(__FILE__, 'thank-you.tpl');
	}
	
	
	
	public function populatePaymentVars()
    {
		global $smarty, $cart, $cookie;

		$address = new Address(intval($cart->id_address_invoice));
		$addressShip = new Address(intval($cart->id_address_delivery));
		$state = new State(intval($address->id_state));
		$address->state = $state->name;
		$state = new State(intval($addressShip->id_state));
		$addressShip->state = $state->name;

		$customer = new Customer(intval($cookie->id_customer));
		$this->apiusername = Configuration::get('EGR_PAYFLOW_USER');
		$this->apipassword = Configuration::get('EGR_PAYFLOW_PASSWORD');
		$this->apisignuture = Configuration::get('EGR_PAYFLOW_VENDOR');
		$this->sandbox = Configuration::get('EGR_PAYFLOW_SANDBOX');
		$this->authCapture = Configuration::get('EGR_AUTH_CAPTURE');//by anu
		
		if (Configuration::get('AUTHORIZENET_CURRENCY') == 'customer')
			$id_currency = intval($cart->id_currency);
		else
			$id_currency = intval(Configuration::get('PS_CURRENCY_DEFAULT'));
		$this->currency = new Currency(intval($id_currency));

		$this->products = $cart->getProducts();
		$id_currency=$cart->id_currency;
		$currency_ob= new Currency(intval($id_currency));
		$currency_1=$currency_ob->getCurrency(intval($id_currency)); 
		$currencycode=$currency_1['iso_code'];
		
		foreach ($this->products as $key => $product)
		{
			$this->products[$key]['name'] = str_replace('"', '\'', $product['name']);
			if (isset($product['attributes']))
				$this->products[$key]['attributes'] = str_replace('"', '\'', $product['attributes']);
			$this->products[$key]['name'] = htmlentities(utf8_decode($product['name']));
			$this->products[$key]['authNetAmount'] = number_format(Tools::convertPrice($product['price_wt'], $this->currency), 2, '.', '');
		}
		$smarty->assign(array(
			'address' => $address,
			'addressShip' => $addressShip,
			'country' => new Country(intval($address->id_country)),
			'customer' => $customer,
			'apiusr' => $this->apiusername,
			'apipwd' => $this->apipassword,
			'apisignature' => $this->apisignuture,
			'apitest' => $this->sandbox,
			'currency' => $currencycode,
			'amount' => number_format(Tools::convertPrice($cart->getOrderTotal(true, 4), $this->currency), 2, '.', ''),
			'shipping' =>  number_format(Tools::convertPrice($cart->getOrderShippingCost(), $this->currency), 2, '.', ''),
			'discounts' => $cart->getDiscounts(),
			'products' => $this->products,
			'total' => number_format(Tools::convertPrice($cart->getOrderTotal(true, 3), $this->currency), 2, '.', ''),
			'cartID' => intval($cart->id),
			'goBackUrl' => 'http://'.htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'order-confirmation.php?key='.$customer->secure_key,
			'returnUrl' => 'http://'.htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/egrpayflowpro/validation.php',
			'this_path' => $this->_path
		));
	}
	public function makeCurlRequest()
	{
		
		global $smarty,$cookie,$cart;
		
		
		
			$customer = new Customer(intval($cookie->id_customer));
		
			$paymentType = urlencode($this->_authCapture);
			$creditCardType =urlencode($_POST['cardName']);
			$card_number =urlencode($_POST['cardNumber']);
		
			$card_expire =urlencode($_POST['expMonth']).urlencode($_POST['expYear']);
			$cvv2Number = urlencode($_POST['cardCode']);
			
			$currency = new Currency($cart->id_currency);
			$currencyCode = $currency->iso_code;
			$customer = new Customer(intval($cookie->id_customer));
		
			$addressInv = new Address(intval($cart->id_address_invoice));
			$countryInv = new Country(intval($addressInv->id_country));
			$stateInv = new State(intval($addressInv->id_state));
			if($addressInv->phone) $phoneInv = $addressInv->phone; else $phoneInv = $addressInv->phone_mobile;
			$addressBil = new Address(intval($cart->id_address_delivery));
			$countryBil = new Country(intval($addressBil->id_country));
			$stateBil = new State(intval($addressInv->id_state));
			if($addressBil->phone) $phoneBil = $addressBil->phone; else $phoneBil = $addressBil->phone_mobile;
			$amount = $cart->getOrderTotal();
			
			
		
		// build hash
		  $tempstr = $card_number . $amount . date('YmdGis') . "1";
		  $request_id = md5($tempstr);
	
		  // body
		  $plist = 'USER=' . $this->_apiUser . '&';
		  $plist .= 'VENDOR=' . $this->_apiVendor. '&';
		  $plist .= 'PARTNER=' . $this->_partner . '&';
		  $plist .= 'PWD=' . $this->_apiPassword . '&';           
		  $plist .= 'TENDER=' . 'C' . '&'; // C = credit card, P = PayPal
		  if($this->_authCapture=='S') 
		  {
			  $status = 2; 
			  $plist .= 'TRXTYPE=' . 'S' . '&'; //  S = Sale transaction, A = Authorisation, C = Credit, D = Delayed Capture, V = Void                        
		  }
		  else 
		  {
			  $status = 11;
			  $plist .= 'TRXTYPE=' . 'A' . '&';
		  }
		  
		  $plist .= 'ACCT=' . $card_number . '&'; 
		  $plist .= 'EXPDATE=' . $card_expire . '&';
		  $plist .= 'NAME='.$creditCardType.'&';
		  $plist .= 'AMT=' . $amount . '&';
		  // extra data
		  $plist .= 'CURRENCY=' . $currencyCode . '&';
		  $plist .= 'COMMENT1=payment&'; 
		  $plist .= 'FIRSTNAME=' . $addressInv->firstname . '&';
		  $plist .= 'LASTNAME=' . $addressInv->lastname . '&';
		  $plist .= 'STREET=' . $addressInv->address1.", ".$addressInv->address2 . '&';
		  $plist .= 'CITY=' . $addressInv->city . '&';     
		  $plist .= 'STATE=' . $stateInv->iso_code . '&';     
		  $plist .= 'ZIP=' . $addressInv->postcode .  '&';      
		  $plist .= 'COUNTRY=' . $countryInv->iso_code . '&';
		  $plist .= 'SHIPTOFIRSTNAME=' . $addressBil->firstname . '&';
		  $plist .= 'SHIPTOLASTNAME=' . $addressBil->lastname . '&';
		  $plist .= 'SHIPTOSTREET=' . $addressBil->address1.", ".$addressBil->address2 . '&';
		  $plist .= 'SHIPTOCITY=' . $addressBil->city . '&';     
		  $plist .= 'SHIPTOSTATE=' . $stateBil->iso_code . '&';     
		  $plist .= 'SHIPTOZIP=' . $addressBil->postcode .  '&';      
		  $plist .= 'SHIPTOCOUNTRY=' . $countryBil->iso_code . '&';
		  $plist .= 'CVV2=' . $cvv2Number . '&';
		  $plist .= 'CLIENTIP=' . $_SERVER['REMOTE_ADDR'] . '&';
		  // verbosity
		 

		  if ($this->validate_card_number($card_number) == false) return 'Card Number not valid';
		  if ($this->validate_card_expire($card_expire) == false) return 'Card Expiration Date not valid';
		  if (!function_exists('curl_init')) return 'Curl function not found.';
		  if (!is_numeric($amount) || $amount <= 0) return 'Amount is not valid';
		  if ($this->_sandbox == 1)	$submiturl = 'https://pilot-payflowpro.paypal.com';   
		  else	$submiturl = 'https://payflowpro.paypal.com';
		  
		  // check for CURL
		  
		
		  
		  
		  $headers = $this->get_curl_headers();
		  $headers[] = "X-VPS-Request-ID: " . $request_id;
	
		  $user_agent = "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)"; // play as Mozilla
		  $ch = curl_init(); 
		  curl_setopt($ch, CURLOPT_URL, $submiturl);
		  curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		  curl_setopt($ch, CURLOPT_USERAGENT, $user_agent);
		  curl_setopt($ch, CURLOPT_HEADER, 1); // tells curl to include headers in response
		  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); // return into a variable
		  curl_setopt($ch, CURLOPT_TIMEOUT, 45); // times out after 45 secs
		  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
		  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); // this line makes it work under https
		  curl_setopt($ch, CURLOPT_POSTFIELDS, $plist); //adding POST data
		  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,  2); //verifies ssl certificate
		  curl_setopt($ch, CURLOPT_FORBID_REUSE, TRUE); //forces closure of connection when done 
		  curl_setopt($ch, CURLOPT_POST, 1); //data sent as POST 
		
		  $result = curl_exec($ch);
		  
		  $headers = curl_getinfo($ch);
		  curl_close($ch);
	
		  $pfpro = $this->get_curl_result($result); //result arrray
		 
		
		  if (isset($pfpro['RESULT']) && $pfpro['RESULT'] == 0) 
		  {
				$msg = $this->l('paypal transaction ID: ') . $pfpro['PNREF'] . "\nMessage : ".$pfpro['RESPMSG'];
				
				$msg .= "\nCard Type: ".$_POST['cardName']."\n Card Expriry Date: ";
				
				$msg .= $_POST['expMonth']."/ ".$_POST['expYear']."\nCVV: ".$_POST['cardCode'];
				if((str_replace(".","",substr(_PS_VERSION_,0,3))*1)>13)
					$this->validateOrder($cart->id, $status, $amount, $this->displayName, $msg,array(), NULL, false, $cart->secure_key);
				else
					$this->validateOrder($cart->id, $status, $amount, $this->displayName, $msg,array(), NULL, false);
					$sql = 'insert into ' . _DB_PREFIX_ . "payflowpro_order values (".$this->currentOrder.",'".$pfpro['PNREF']."','".$this->_authCapture."')";
					Db::getInstance()->Execute($sql);
					return 'accepted';
			
		  } else {
			return 'Error code : '. $pfpro['RESULT']. '<br>Response Message :' .$pfpro['RESPMSG'];
		  }
	}
	
  
	
	public function makeCaptureCurlRequest($capamt,$captran,$capodr,$captot,$capcurr)
	{
		
		global $smarty,$cookie;
		
      // body
		$plist = 'USER=' . $this->_apiUser . '&';
		$plist .= 'VENDOR=' . $this->_apiVendor. '&';
		$plist .= 'PARTNER=' . $this->_partner . '&';
		$plist .= 'PWD=' . $this->_apiPassword . '&';  
		$plist .= 'TENDER=' . 'C' . '&'; // C = credit card, P = PayPal
		$plist .= 'TRXTYPE=' . 'D' . '&'; //  S = Sale transaction, A = Authorisation, C = Credit, D = Delayed Capture, V = Void                        
		$plist .= "ORIGID=" . $captran . "&"; // ORIGID to the PNREF value returned from the original transaction
		$plist .= 'VERBOSITY=MEDIUM';
		if ($this->_sandbox == 1)	$submiturl = 'https://pilot-payflowpro.paypal.com';   
		else	$submiturl = 'https://payflowpro.paypal.com';
		  
		$headers = $this->get_curl_headers();
      
		$user_agent = "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)";
		$ch = curl_init(); 
		curl_setopt($ch, CURLOPT_URL, $submiturl);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_USERAGENT, $user_agent);
		curl_setopt($ch, CURLOPT_HEADER, 1); // tells curl to include headers in response
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); // return into a variable
		curl_setopt($ch, CURLOPT_TIMEOUT, 45); // times out after 45 secs
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); // this line makes it work under https
		curl_setopt($ch, CURLOPT_POSTFIELDS, $plist); //adding POST data
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,  2); //verifies ssl certificate
		curl_setopt($ch, CURLOPT_FORBID_REUSE, TRUE); //forces closure of connection when done 
		curl_setopt($ch, CURLOPT_POST, 1); //data sent as POST 
      
		$result = curl_exec($ch);
		  
		$headers = curl_getinfo($ch);
		curl_close($ch);
		      
		$pfpro = $this->get_curl_result($result); //result arrray
		if (isset($pfpro['RESULT']) && $pfpro['RESULT'] == 0) 
		    {
			  $empid = $cookie->id_employee;
				  $sql = "insert into "._DB_PREFIX_."order_history values('','$empid','$capodr','2',now()) ";
				  Db::getInstance()->Execute($sql);
				  $tran= $pfpro['PNREF'];
				  $sql = 'update ' . _DB_PREFIX_ . "payflowpro_order set id_transaction ='$tran', transaction_type='S' where id_order = $capodr ";
				  Db::getInstance()->Execute($sql);
				  return 1;	
		    }
		    else
		    {		 
			return 'Error code : '. $pfpro['RESULT']. '<br>Response Message :' .$pfpro['RESPMSG'];     
		    }     
	}
	
	public function makeRefundCurlRequest($refamt,$reftran,$refodr,$reftot,$refcurr)
	{
		
		global $smarty,$cookie,$cookie;
		
		// body
		  $plist = 'USER=' . $this->_apiUser . '&';
			  $plist .= 'VENDOR=' . $this->_apiVendor. '&';
			  $plist .= 'PARTNER=' . $this->_partner . '&';
			  $plist .= 'PWD=' . $this->_apiPassword . '&';  
			  $plist .= 'TENDER=' . 'C' . '&'; // C = credit card, P = PayPal
			  $plist .= 'TRXTYPE=' . 'V' . '&'; //  S = Sale transaction, A = Authorisation, C = Credit, D = Delayed Capture, V = Void                        
			  $plist .= "ORIGID=" . $reftran . "&"; // ORIGID to the PNREF value returned from the original transaction
		          $plist .= 'VERBOSITY=MEDIUM';
			  if ($this->_sandbox == 1)	$submiturl = 'https://pilot-payflowpro.paypal.com';   
			  else	$submiturl = 'https://payflowpro.paypal.com';
			    
		$headers = $this->get_curl_headers();
		
		$user_agent = "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)";
		$ch = curl_init(); 
		curl_setopt($ch, CURLOPT_URL, $submiturl);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_USERAGENT, $user_agent);
		curl_setopt($ch, CURLOPT_HEADER, 1); // tells curl to include headers in response
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); // return into a variable
		curl_setopt($ch, CURLOPT_TIMEOUT, 45); // times out after 45 secs
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); // this line makes it work under https
		curl_setopt($ch, CURLOPT_POSTFIELDS, $plist); //adding POST data
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,  2); //verifies ssl certificate
		curl_setopt($ch, CURLOPT_FORBID_REUSE, TRUE); //forces closure of connection when done 
		curl_setopt($ch, CURLOPT_POST, 1); //data sent as POST 
		
		$result = curl_exec($ch);
			    
		$headers = curl_getinfo($ch);
		curl_close($ch);
		      
		$pfpro = $this->get_curl_result($result); //result arrray
		if (isset($pfpro['RESULT']) && $pfpro['RESULT'] == 0) 
		    {
			  $history = new OrderHistory();
				  global $cookie;
				  $empid = $cookie->id_employee;
				  $sql = "insert into "._DB_PREFIX_."order_history values('','$empid','$refodr','7',now()) ";
				  Db::getInstance()->Execute($sql);
				  $sql = "update "._DB_PREFIX_."orders set total_discounts=0.00,total_paid=0.00,total_paid_real=0.00,
				  total_products=0.00,total_products_wt=0.00,total_shipping=0.00,carrier_tax_rate=0.00,total_wrapping=0.00,
				  invoice_number=0,delivery_number=0,	invoice_date=NULL ,	delivery_date=NULL
				  where id_order =  $refodr";
				  Db::getInstance()->Execute($sql);
				  $sql = "delete from "._DB_PREFIX_."order_detail where id_order = $refodr ";
				  Db::getInstance()->Execute($sql);
				  $tran= $pfpro['PNREF'];
				  $sql = 'update ' . _DB_PREFIX_ . "payflowpro_order set id_transaction ='$tran', transaction_type='Refund' where id_order = $refodr ";
				  Db::getInstance()->Execute($sql);
				  return 1;			
		    }
		    else
		    {     
			return 'Error code : '. $pfpro['RESULT']. '<br>Response Message :' .$pfpro['RESPMSG'];     
		    }     
		
	}
	
	public function home()
	{
		$html = '<h2>Paypal</h2>';
		if (isset($_POST['submitPaypalSettings']) OR isset($_POST['submitegrpayflowpro']))
		{
			$errors = $this->_checkValues();
			if (!sizeof($errors))
			{
				$this->_updateValues();
				$html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" />'.$this->l('Settings updated').'</div>';
			}
			else
				$html .= $this->_displayErrors($errors);
		}
		else if (isset($_POST['capodr']))
		{
			$response = $this->_updateValues();
			if($response == 1)
			{
				$html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" />'.$this->l('Payment has been captured').'</div>';
			}
			else
			{
				$errors[] = $response;
				$html .= $this->_displayErrors($errors);
			}
		}
		else if (isset($_POST['refodr']))
		{
			$response = $this->_updateValues();
			if($response == 1)
			{
				$html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" />'.$this->l('Payment has been refunded').'</div>';
			}
			else
			{
				$errors[] = $response;
				$html .= $this->_displayErrors($errors);
			}
		}
		$html .= $this->_displayFormSettings();
		return $html;
	}

	private function _checkValues()
	{
		$errors = array();

		if (isset($_POST['submitPaypalSettings']))
		{
			if (!isset($_POST['sandbox']))
				$_POST['sandbox'] = 1;
		}
		
	}

	private function _updateValues()
	{
		if (Tools::isSubmit('submitPaypalSettings'))
		{
			Configuration::updateValue('EGR_PAYFLOW_SANDBOX', intval($_POST['sandbox']));
			Configuration::updateValue('EGR_PAYFLOW_CURRENCY', intval($_POST['egrcur']));
			Configuration::updateValue('EGR_AUTH_CAPTURE',$_POST['method_capture']);//by anu
		}
		elseif (Tools::isSubmit('submitegrpayflowpro'))
		{
			Configuration::updateValue('EGR_PAYFLOW_USER', strval($_POST['apiUser']));
			Configuration::updateValue('EGR_PAYFLOW_PASSWORD', strval($_POST['apiPassword']));
			Configuration::updateValue('EGR_PAYFLOW_VENDOR', strval($_POST['apiVendor']));
			Configuration::updateValue('EGR_PAYFLOW_PARTNER', strval($_POST['apiPartner']));
		}
		else  if (isset($_POST['capodr']))
		{
			$response = $this->makeCaptureCurlRequest($_POST['capamt'],$_POST['captran'],$_POST['capodr'],$_POST['captot'],$_POST['capcurr']);
			if($response == 1)
			{
				return 1;
			}
			else
			{
				return $response;
			}
		}
		else  if (isset($_POST['refodr']))
		{
			$response = $this->makeRefundCurlRequest($_POST['refamt'],$_POST['reftran'],$_POST['refodr'],$_POST['reftot'],$_POST['refcurr']);
			if($response == 1)
			{
				return 1;
			}
			else
			{
				return $response;
			}
		}
	}

	private function _displayErrors($errors)
	{
		$nbErrors = sizeof($errors);
		$html = '
		<div class="alert error">
			<h3>'.($nbErrors > 1 ? $this->l('There are') : $this->l('There is')).' '.$nbErrors.' '.($nbErrors > 1 ? $this->l('errors') : $this->l('error')).'</h3>
			<ol>';
		foreach ($errors AS $error)
			$html .= '<li>'.$error.'</li>';
		$html .= '
			</ol>
		</div>';
		return $html;
	}

	private function _displayFormSettings()
	{
		$sandbox = Configuration::get('EGR_PAYFLOW_SANDBOX');
		$authCapture = Configuration::get('EGR_AUTH_CAPTURE');
		$pcurrency = Configuration::get('EGR_PAYFLOW_CURRENCY');
		
		
		$apiUser = Configuration::get('EGR_PAYFLOW_USER');
		$apiPassword = Configuration::get('EGR_PAYFLOW_PASSWORD');
		$vendor = Configuration::get('EGR_PAYFLOW_VENDOR');
		$partner = Configuration::get('EGR_PAYFLOW_PARTNER');
		

		$html= '
			<script type="text/javascript">
				var pos_select = '.(($tab = (int)Tools::getValue('tabs')) ? $tab : '0').';
			</script>
			<script type="text/javascript" src="'._MODULE_DIR_.'egrpayflowpro/js/tabpane.js"></script>
			<link type="text/css" rel="stylesheet" href="'._MODULE_DIR_.'egrpayflowpro/css/tabpane.css" />
			
			
			
			<div class="tab-pane" id="tab-pane-1" style="width:900px;">
				 <div class="tab-page" id="step1">
					<h4 class="tab">'.$this->l('Settings').'</h2>
					
					<table>
					<tr>
					<td>
					<form action="'.strval($_SERVER['REQUEST_URI']).'" method="post" style="margin-top:20px; float:left;">
					<input type="hidden" name="tabs" id="tabs" value="0" />
					<h2>'.$this->l('General settings:').'</h2>
					<label style="width:140px;">'.$this->l('Sandbox mode:').'</label>
					<div class="margin-form" style="padding-left:160px;">
						<input type="radio" name="sandbox" value="1" '.($sandbox ? 'checked="checked"' : '').' /> '.$this->l('Yes').'
						<input type="radio" name="sandbox" value="0" '.(!$sandbox ? 'checked="checked"' : '').' /> '.$this->l('No').'
					</div>
					<label style="width:140px;">'.$this->l('Currency Convertion:').'</label>
					<div style="padding-left:160px;">
					<select name="egrcur"><option value="0"></option>'; 
					$result = Db::getInstance()->ExecuteS('select id_currency,iso_code from ' ._DB_PREFIX_ . "currency
					where deleted = 0 and iso_code in ('AUD', 'CAD','EUR','GBP','JPY','USD','NZD','CHF','HKD','SGD','SEK', 'DKK','PLN','NOK','HUF','CZK','ILS','MXN','BRL', 'MYR','PHP','TWD','THB') " );
					$i=0;
		
					foreach($result as $row)
					{
						if($row['id_currency'] == Configuration::get('EGR_PAYFLOW_CURRENCY'))
						$html.=	"<option value='".$row['id_currency']."' selected='selected'>".$row['iso_code']."</option>";
						else 
						$html.=	"<option value='".$row['id_currency']."' >".$row['iso_code']."</option>"; 
					}
					$html.=	'</select>
					</div>
					<br>
					
					<label style="width:140px;">'.$this->l('Payment Method:').'</label>
					<div class="margin-form" style="padding-left:160px;">
						<input type="radio" name="method_capture" value="S" '.(($authCapture == 'S') ? 'checked="checked"' : '').' /> '.$this->l('Authorize & Capture').'
						<input type="radio" name="method_capture" value="A" '.(($authCapture  == 'A')? 'checked="checked"' : '').' /> '.$this->l('Authorize Only').'
					</div>
					<center style="clear:both; margin-top:0px;"><input type="submit" name="submitPaypalSettings" value="'.$this->l('Update settings').'" class="button" /></center>
					</form>
					</td>
					<td>
					<form action="'.strval($_SERVER['REQUEST_URI']).'" method="post" style="margin-top:20px; float:left;">
					<h2>'.$this->l('API settings:').'</h2>
					<label style="width:140px;">'.$this->l('API user:').'</label>
					<div class="margin-form" style="padding-left:160px;"><input type="text" size="33" name="apiUser" value="'.($apiUser ? htmlentities($apiUser, ENT_COMPAT, 'UTF-8') : '').'" /></div>
					<label style="width:140px;">'.$this->l('API password:').'</label>
					<div class="margin-form" style="padding-left:160px;"><input type="password" size="33" name="apiPassword" value="'.($apiPassword ? htmlentities($apiPassword, ENT_COMPAT, 'UTF-8') : '').'" /></div>
					<label style="width:140px;">'.$this->l('API Vendor:').'</label>
					<div class="margin-form" style="padding-left:160px;"><input type="text" size="33" name="apiVendor" value="'.($vendor ? htmlentities($vendor, ENT_COMPAT, 'UTF-8') : '').'" /></div>
					
					<label style="width:140px;">'.$this->l('API Partner:').'</label>
					<div class="margin-form" style="padding-left:160px;"><input type="text" size="33" name="apiPartner" value="'.($partner ? htmlentities($partner, ENT_COMPAT, 'UTF-8') : '').'" /></div>
					<br />
					<center style="clear:both;"><input type="submit" name="submitegrpayflowpro" value="'.$this->l('Update settings').'" class="button" /></center>
					</form>
					</td>
					</tr>
					</table>
					
				</div>
				
				
				
				<div class="tab-page" id="step2" style="width:900px;">
					<h4 class="tab">'.$this->l('Capture').'</h4>
					<h2>'.$this->l('Capture').'</h2>
					
					<table class="table" style="width:100%;" ><tr><th>S.No.</th><th>Order ID</th>
						<th>Order Date</th><th>Transation ID</th><th>Customer Name</th><th>Total Amount</th><th></th></tr>';
						$result = Db::getInstance()->ExecuteS("
						select distinct a.id_order as oid,d.date_add as odt,total_paid as amt,
						id_transaction as tran, CONCAT(firstname,' ',lastname) as cname,iso_code as curr,sign 	
						from " ._DB_PREFIX_ . 'order_history a
						inner join 
						(
							select id_order,max(date_add) as maxdt
							from ' ._DB_PREFIX_ . 'order_history
							group by id_order
						) as b on a.id_order = b.id_order and date_add=maxdt 
						inner join ' ._DB_PREFIX_ . "payflowpro_order c on a.id_order = c.id_order and 	transaction_type = 'A'
						inner join "._DB_PREFIX_ . "orders d on a.id_order = d.id_order
						inner join "._DB_PREFIX_ . "customer e on d.id_customer  = e.id_customer
						inner join "._DB_PREFIX_ . "currency f on f.id_currency = d.id_currency
						where a.id_order_state=11");
						$i=0;
			//echo nl2br();
						if(count($result))
						foreach($result as $row)
						{
							$i++;
							$html.=	'
							<form action="'.strval($_SERVER['REQUEST_URI']).'" method="post" style="margin-top:20px; float:left;">
							<input type="hidden" name="tabs" id="tabs" value="1" />'."
							<tr><td>$i</td><td>".$row['oid']."</td><td>".$row['odt']."</td><td>".$row['tran']."</td>
							<td>".$row['cname']."</td><td align='right'>".$row['sign']." ".$row['amt']."</td>
							<td>
								<input type='hidden' name='capamt' size='5'>
								<input type='hidden' name='captran' size='5' value='".$row['tran']."'>
								<input type='hidden' name='capodr' size='5' value='".$row['oid']."'>
								<input type='hidden' name='captot' size='5' value='".$row['amt']."'>
								<input type='hidden' name='capcurr' size='5' value='".$row['curr']."'>
								<input type='button' onclick='confirmation(this.form)'  name='submitcapamt' value='".$this->l('Capture')."' class='button' />
							</td>
							</tr>
							</form>";
						}
						$html.=	'</table>
				</div>
				
				
				<div class="tab-page" id="step3" style="width:900px;">
					<h4 class="tab">'.$this->l('Refund').'</h4>
					<h2>'.$this->l('Refund').'</h2>
					<table class="table" style="width:100%;" ><tr><th>S.No.</th><th>Order ID</th>
						<th>Order Date</th><th>Transation ID</th><th>Customer Name</th><th>Total Amount</th><th></th></tr>';
						$result = Db::getInstance()->ExecuteS("
						select distinct a.id_order as oid,d.date_add as odt,total_paid as amt,
						id_transaction as tran, CONCAT(firstname,' ',lastname) as cname,iso_code as curr,sign 	
						from " ._DB_PREFIX_ . 'order_history a
						inner join 
						(
							select id_order,max(date_add) as maxdt
							from ' ._DB_PREFIX_ . 'order_history
							group by id_order
						) as b on a.id_order = b.id_order and date_add=maxdt 
						inner join ' ._DB_PREFIX_ . "payflowpro_order c on a.id_order = c.id_order and 	transaction_type = 'S'
						inner join "._DB_PREFIX_ . "orders d on a.id_order = d.id_order
						inner join "._DB_PREFIX_ . "customer e on d.id_customer  = e.id_customer
						inner join "._DB_PREFIX_ . "currency f on f.id_currency = d.id_currency
						where a.id_order_state=2");
						$i=0;
			//echo nl2br();
						foreach($result as $row)
						{
							$i++;
							$html.=	'
							<form action="'.strval($_SERVER['REQUEST_URI']).'" method="post" style="margin-top:20px; float:left;">
							<input type="hidden" name="tabs" id="tabs" value="2" />'."
							<tr><td>$i</td><td>".$row['oid']."</td><td>".$row['odt']."</td><td>".$row['tran']."</td>
							<td>".$row['cname']."</td><td align='right'>".$row['sign']." ".$row['amt']."</td>
							<td>
								<input type='hidden' name='refamt' size='5'>
								<input type='hidden' name='reftran' size='5' value='".$row['tran']."'>
								<input type='hidden' name='refodr' size='5' value='".$row['oid']."'>
								<input type='hidden' name='reftot' size='5' value='".$row['amt']."'>
								<input type='hidden' name='refcurr' size='5' value='".$row['curr']."'>
								<input type='button' onclick='confirmation2(this.form)'  name='submitrefamt' value='".$this->l('Refund')."' class='button' />
							</td>
							</tr>
							</form>";
						}
						$html.=	'</table>
				</div>
				
				
				
				
				<div class="tab-page" id="step4" style="width:900px;">
					<h4 class="tab">'.$this->l('Help').'</h2>
					'.$this->l('Follow these steps in order to obtain your API authentication information by using an API signature as the authentication mechanism. If you are testing with a virtual account, repeat these steps both on the virtual account and on the real account at the same time. We recommend that you open a separate Web browser session when carrying out this procedure.').'<br /><br />
			'.$this->l('1. Log in to your PayPal Premier or Business account.').'<br /><br />
			'.$this->l('2. Click the Profile subtab located under the My Account heading.').'<br /><br />
			'.$this->l('3. Click the API Access link under the Account Information header.').'<br /><br />
			'.$this->l('4. Click the View API Certificate link in the right column.').'<br /><br />
			'.$this->l('5. Click the Request API Credentials link.').'<br /><br />
			'.$this->l('6. Click the Request API signature radio button on the Request API Credentials page.').'<br /><br />
			'.$this->l('7. Complete the Request API Credential Request form by clicking the agreement checkbox and clicking Submit.').'<br /><br />
			'.$this->l('8. Save the values for API Username, Password and Signature (make sure this long character signature is copied).').'<br /><br />
			'.$this->l('9. Click the Done button after copying your API Username, Password, and Signature.').'<br /><br />
			'.$this->l('10. This will take you back to the API Access screen where you are finished.').'
				</div>
			</div>
			<div class="clear"></div>
			<script type="text/javascript">
				function loadTab(id){}
				setupAllTabs();
			</script>
			';
		
		return $html;
	}
	public function get_curl_headers()
	{
		$headers = array();
		
		$headers[] = "Content-Type: text/namevalue"; //or maybe text/xml
		$headers[] = "X-VPS-Timeout: 30";
		$headers[] = "X-VPS-VIT-OS-Name: Linux";  // Name of your OS
		$headers[] = "X-VPS-VIT-OS-Version: RHEL 4";  // OS Version
		$headers[] = "X-VPS-VIT-Client-Type: PHP/cURL";  // What you are using
		$headers[] = "X-VPS-VIT-Client-Version: 0.01";  // For your info
		$headers[] = "X-VPS-VIT-Client-Architecture: x86";  // For your info
		$headers[] = "X-VPS-VIT-Client-Certification-Id: 13fda2433fc2123d8b191d2d011b7fdc"; // get this from payflowintegrator@paypal.com
		$headers[] = "X-VPS-VIT-Integration-Product: MyApplication";  // For your info, would populate with application name
		$headers[] = "X-VPS-VIT-Integration-Version: 0.01"; // Application version    
		
		return $headers;  
	}

    // parse result and return an array
    
    public function get_curl_result($result)
    {
	if (empty($result)) return;
  
	$pfpro = array();
	$result = strstr($result, 'RESULT');    
	$valArray = explode('&', $result);
	foreach($valArray as $val) {
	  $valArray2 = explode('=', $val);
	  $pfpro[$valArray2[0]] = $valArray2[1];
	}
	return $pfpro;    
    }

    public function validate_card_expire($mmyy)
    {
	if (!is_numeric($mmyy) || strlen($mmyy) != 4) {
	  return false;
	}      
	$mm = substr($mmyy, 0, 2);
	$yy = substr($mmyy, 2, 2);        
	if ($mm < 1 || $mm > 12) {
	  return false;
	}
	$year = date('Y');
	$yy = substr($year, 0, 2) . $yy; // eg 2007
	if (is_numeric($yy) && $yy >= $year && $yy <= ($year + 10)) {
	} else {
	  return false;
	}
	if ($yy == $year && $mm < date('n')) {
	  return false;
	}      
	return true;
    }

    // luhn algorithm
    public function validate_card_number($card_number)
    {
	$card_number = preg_replace('[^0-9]', '', $card_number);      
	if ($card_number < 9) return false;
	$card_number = strrev($card_number);
	$total = 0;
	for ($i = 0; $i < strlen($card_number); $i++) {
	  $current_number = substr($card_number, $i, 1);
	  if ($i % 2 == 1) {
	    $current_number *= 2;
	  }
	  if ($current_number > 9) {
	    $first_number = $current_number % 10;
	    $second_number = ($current_number - $first_number) / 10;
	    $current_number = $first_number + $second_number;
	  }
	  $total += $current_number;
	}
	return ($total % 10 == 0);
    }

    public function get_errors()
    {
	if ($this->errors != '') {
	  return $this->errors;
	}
	return false;
    }
  
    public function set_errors($string)
    {
      $this->errors = $string;
    }

    public function get_version()
    {
      return '4.03';
    } 
}