{*
* Template Prestashop DiscountShop
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*}

{capture name=path}<a href="{$link->getPageLink('my-account.php', true)}" title="{l s='My account'}">{l s='My account'}</a><span class="navigation-pipe">{$navigationPipe}</span>{l s='Order history'}{/capture}
{include file="$tpl_dir./breadcrumb.tpl"}
{include file="$tpl_dir./errors.tpl"}

<h1>{l s='Order history'}</h1>

{if $slowValidation}<p class="warning">{l s='If you have just placed an order, it may take a few minutes for it to be validated. Please refresh this page if your order is missing.'}</p>{/if}

<div class="block-center" id="block-history">
	{if $orders && count($orders)}
	<table id="order-list" class="std">
		<thead>
			<tr>
				<th class="order_history_link first_item">{l s='Order'}</th>
				<th class="order_history_date item">{l s='Date'}</th>
				<th class="order_history_price item">{l s='Total price'}</th>
				<th class="order_history_method item">{l s='Payment'}</th>
				<th class="order_history_state item">{l s='Status'}</th>
				<th class="order_history_invoice item center">{l s='Invoice'}</th>
				<th class="order_history_detail last_item">&nbsp;</th>
			</tr>
		</thead>
		<tbody>
		{foreach from=$orders item=order name=myLoop}
			<tr class="{if $smarty.foreach.myLoop.first}first_item{elseif $smarty.foreach.myLoop.last}last_item{else}item{/if}{if $smarty.foreach.myLoop.index % 2} alternate_item{/if}">
				<td class="order_history_link bold">
					{if isset($order.invoice) && $order.invoice && isset($order.virtual) && $order.virtual}<i class="icon-download"></i>{/if}
					<a class="color-myaccount" href="javascript:showOrder(1, {$order.id_order|intval}, '{$link->getPageLink('order-detail.php', true)}');">{if isset($order.reference) && $order.reference}{Order::getUniqReferenceOf($order.id_order)}{else}{l s='#'}{$order.id_order|string_format:"%06d"}{/if}</a>
				</td>
				<td class="order_history_date bold">{dateFormat date=$order.date_add full=0}</td>
				<td class="order_history_price"><span class="price">{displayPrice price=$order.total_paid currency=$order.id_currency no_utf8=false convert=false}</span></td>
				<td class="order_history_method">{$order.payment|escape:'html':'UTF-8'}</td>
				<td class="order_history_state bold">{if isset($order.order_state)}{$order.order_state|escape:'html':'UTF-8'}{/if}</td>
				<td class="order_history_invoice center">
				{if (isset($order.invoice) && $order.invoice && isset($order.invoice_number) && $order.invoice_number) && isset($invoiceAllowed) && $invoiceAllowed == true}
					<a href="{$link->getPageLink('pdf-invoice.php', true)}?id_order={$order.id_order|intval}" title="{l s='Invoice'}"><i class="icon-file-text"></i></a>
				{else}-{/if}
				</td>
				<td class="order_history_detail">
					<a class="color-myaccount" href="javascript:showOrder(1, {$order.id_order|intval}, '{$link->getPageLink('order-detail.php', true)}');">{l s='details'}</a>
				</td>
			</tr>
		{/foreach}
		</tbody>
	</table>
	<div id="block-order-detail" class="hidden">&nbsp;</div>
	{else}
		<p class="warning">{l s='You have not placed any orders.'}</p>
	{/if}
</div>

<ul class="footer_links">
	<li><a href="{$link->getPageLink('my-account.php', true)}" title="{l s='Back to your account'}">{l s='Back to your account'}</a></li>
	<li><a href="{$base_dir_ssl}" title="{l s='Home'}">{l s='Home'}</a></li>
</ul>