<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

include_once 'classes/USPSShippingServices.php';
include_once 'classes/USPSShippingCache.php';
class WkUspsShipping extends CarrierModule
{
    const INSTALL_SQL_FILE = 'install.sql';
    private $_html = '';
    public $id_carrier;

    public function __construct()
    {
        $this->name = 'wkuspsshipping';
        $this->tab = 'shipping_logistics';
        $this->version = '1.7.2';
        $this->author = 'Webkul';
        $this->module_key    = '25f56339237c18b652fef58ea8761b21';
        $this->need_instance = 1;
        $this->bootstrap = true;
        $this->module_key = '25f56339237c18b652fef58ea8761b21';

        parent::__construct();
        $this->displayName = $this->l('USPS Shipping');
        $this->description = $this->l('Provide USPS shipping methods for products.');
    }

    public function getContent()
    {
        if (Tools::isSubmit('updateuspsAccInfo') || Tools::isSubmit('updateuspsPackaging')) {
            $this->_postValidation();
            if (empty($this->_postErrors)) {
                $this->_postProcess();
            } else {
                foreach ($this->_postErrors as $err) {
                    $this->_html .= $this->displayError($err);
                }
            }
        } else {
            $this->_html .= '<br />';
        }

        $this->_html .= $this->renderForm();
        $this->context->smarty->assign(
            array(
                'USPS_SIZE_DOMESTIC' => Configuration::get('WK-USPS-SIZE-DOMESTIC'),
                'USPS_CONTAINER_DOMESTIC' => Configuration::get('WK-USPS-CONTAINER-DOMESTIC'),
                'USPS_SIZE_INTERNATIONAL' => Configuration::get('WK-USPS-SIZE-INTERNATIONAL'),
                'USPS_CONTAINER_INTERNATIONAL' => Configuration::get('WK-USPS-CONTAINER-INTERNATIONAL'),
                'USPS_MACHINABLE' => Configuration::get('WK-USPS-MACHINABLE'),
                'USPS_WIDTH' => Configuration::get('WK-USPS-WIDTH'),
                'USPS_HEIGHT' => Configuration::get('WK-USPS-HEIGHT'),
                'USPS_LENGTH' => Configuration::get('WK-USPS-LENGTH'),
                'USPS_GIRTH' => Configuration::get('WK-USPS-GIRTH'),
                'USPS_WEIGHT' => Configuration::get('WK-USPS-WEIGHT'),
                'weight_unit' => Configuration::get('PS_WEIGHT_UNIT'),
                'dimension_unit' => Configuration::get('PS_DIMENSION_UNIT')
            )
        );
        $this->_html .= $this->context->smarty->fetch($this->local_path.'views/templates/admin/packaging.tpl');

        return $this->_html;
    }

    private function _postValidation()
    {
        if (Tools::isSubmit('updateuspsAccInfo')) {
            if (!Tools::getValue('WK-USPS-ID')) {
                $this->_postErrors[] = $this->l('Enter USPS user id');
            }
            if (!Tools::getValue('WK-USPS-ORIGIN-ZIPCODE')) {
                $this->_postErrors[] = $this->l('Enter origin zipcode');
            }
        } elseif (Tools::isSubmit('updateuspsPackaging')) {
            if (Tools::getValue('usps_width') == '') {
                $this->_postErrors[] = $this->l('Dimension width is required field.');
            } elseif (!Validate::isUnsignedFloat(Tools::getValue('usps_width'))) {
                $this->_postErrors[] = $this->l('Dimension width must be numeric.');
            } elseif (Tools::getValue('usps_width') <= 0) {
                $this->_postErrors[] = $this->l('Dimension width must be greater than Zero.');
            }

            if (Tools::getValue('usps_height') == '') {
                $this->_postErrors[] = $this->l('Dimension height is required field.');
            } elseif (!Validate::isUnsignedFloat(Tools::getValue('usps_height'))) {
                $this->_postErrors[] = $this->l('Dimension height must be numeric.');
            } elseif (Tools::getValue('usps_height') <= 0) {
                $this->_postErrors[] = $this->l('Dimension height must be greater than Zero.');
            }

            if (Tools::getValue('usps_length') == '') {
                $this->_postErrors[] = $this->l('Dimension length is required field.');
            } elseif (!Validate::isUnsignedFloat(Tools::getValue('usps_length'))) {
                $this->_postErrors[] = $this->l('Dimension length must be numeric.');
            } elseif (Tools::getValue('usps_length') <= 0) {
                $this->_postErrors[] = $this->l('Dimension length must be greater than Zero.');
            }

            if (Tools::getValue('usps_girth') == '') {
                $this->_postErrors[] = $this->l('Dimension girth is required field.');
            } elseif (!Validate::isUnsignedFloat(Tools::getValue('usps_girth'))) {
                $this->_postErrors[] = $this->l('Dimension girth must be numeric.');
            } elseif (Tools::getValue('usps_girth') <= 0) {
                $this->_postErrors[] = $this->l('Dimension girth must be greater than Zero.');
            }

            if (Tools::getValue('usps_weight') == '') {
                $this->_postErrors[] = $this->l('Weight is required field.');
            } elseif (!Validate::isUnsignedFloat(Tools::getValue('usps_weight'))) {
                $this->_postErrors[] = $this->l('Weight must be numeric.');
            } elseif (Tools::getValue('usps_weight') <= 0) {
                $this->_postErrors[] = $this->l('Weight must be greater than Zero.');
            }
        }
    }

    private function _postProcess()
    {
        if (Tools::isSubmit('updateuspsAccInfo')) {
            $usps_userid = Tools::getValue('WK-USPS-ID');
            $origin_zipcode = Tools::getValue('WK-USPS-ORIGIN-ZIPCODE');
            $wsParams = array();
            $wsParams['user_id'] = $usps_userid;
            $wsParams['originzipcode'] = $origin_zipcode;
            $wsParams['recipient_postalcode'] = $origin_zipcode;
            $wsParams['size'] = 'LARGE';
            $wsParams['container'] = 'RECTANGULAR';
            $wsParams['weight'] = 1;
            $wsParams['width'] = 1;
            $wsParams['length'] = 1;
            $wsParams['girth'] = 1;
            $wsParams['height'] = 1;
            $wsParams['machinable'] = 'TRUE';
            $is_details_valid = $this->uspsDomestic($wsParams);
            if ($is_details_valid) {
                Configuration::updateValue('WK-USPS-ID', $usps_userid);
                Configuration::updateValue('WK-USPS-ORIGIN-ZIPCODE', $origin_zipcode);
                Configuration::updateValue('WK-USPS-HANDLING', Tools::getValue('WK-USPS-HANDLING'));
                $this->_html .= $this->displayConfirmation($this->l('Settings updated.'));
                USPSShippingCache::clearUspsRateCache();
            } else {
                $this->_html .= $this->displayError($this->l('Authorization failure. USPS (User) ID OR 	Origin Zipcode is incorrect.'));
            }
        } elseif (Tools::isSubmit('updateuspsPackaging')) {
            Configuration::updateValue('WK-USPS-SIZE-DOMESTIC', Tools::getValue('usps_size_domestic'));
            Configuration::updateValue('WK-USPS-CONTAINER-DOMESTIC', Tools::getValue('usps_container_domestic'));
            Configuration::updateValue('WK-USPS-SIZE-INTERNATIONAL', Tools::getValue('usps_size_international'));
            Configuration::updateValue('WK-USPS-CONTAINER-INTERNATIONAL', Tools::getValue('usps_container_international'));
            Configuration::updateValue('WK-USPS-MACHINABLE', Tools::getValue('usps_machinable'));
            Configuration::updateValue('WK-USPS-WIDTH', Tools::getValue('usps_width'));
            Configuration::updateValue('WK-USPS-HEIGHT', Tools::getValue('usps_height'));
            Configuration::updateValue('WK-USPS-LENGTH', Tools::getValue('usps_length'));
            Configuration::updateValue('WK-USPS-GIRTH', Tools::getValue('usps_girth'));
            Configuration::updateValue('WK-USPS-WEIGHT', Tools::getValue('usps_weight'));
            $this->_html .= $this->displayConfirmation($this->l('Settings updated.'));
            USPSShippingCache::clearUspsRateCache();
        }
    }

    public function renderForm()
    {
        $fields_form = array();
        $fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('General Configuration'),
                'icon' => 'icon-cogs',
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('USPS (User) ID :'),
                    'name' => 'WK-USPS-ID',
                    'required' => true,
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Origin Zipcode :'),
                    'name' => 'WK-USPS-ORIGIN-ZIPCODE',
                    'required' => true,
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Is prestashop shipping handling fee add in USPS shipping'),
                    'name' => 'WK-USPS-HANDLING',
                    'class' => 't',
                    'required' => true,
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Enabled'),
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Disabled'),
                        ),
                    ),
                    'hint' => $this->l('If Yes, prestashop handling fee will be added in USPS shipping fee.'),
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
                'name' => 'updateuspsAccInfo',
            ),
        );

        $helper = new HelperForm();
        // Module, token and currentIndex
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        // Title and toolbar
        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->table = $this->table;
        $helper->identifier = $this->identifier;
        //Language
        $helper->default_form_language = (int) Configuration::get('PS_LANG_DEFAULT');
        $helper->allow_employee_form_lang = (int) Configuration::get('PS_LANG_DEFAULT');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm($fields_form);
    }

    public function getConfigFieldsValues()
    {
        return array(
            'WK-USPS-ID' => Tools::getValue('WK-USPS-ID', Configuration::get('WK-USPS-ID')),
            'WK-USPS-ORIGIN-ZIPCODE' => Tools::getValue('WK-USPS-ORIGIN-ZIPCODE', Configuration::get('WK-USPS-ORIGIN-ZIPCODE')),
            'WK-USPS-HANDLING' => Tools::getValue('WK-USPS-HANDLING', Configuration::get('WK-USPS-HANDLING'))
        );
    }

    public function hookUpdateCarrier($params)
    {
        $id_carrier = $params['id_carrier'];
        if ($id_carrier) {
            $new_id_carrier = $params['carrier']->id;
            $obj_usps_services = new USPSShippingServices();
            $obj_usps_services->updateIdCarrierByIdCarrier($new_id_carrier, $id_carrier);
        }
    }

    public function install()
    {
        if (Currency::getIdByIsoCode('USD')) {
            if (!file_exists(dirname(__FILE__).'/'.self::INSTALL_SQL_FILE)) {
                return (false);
            } elseif (!$sql = Tools::file_get_contents(dirname(__FILE__).'/'.self::INSTALL_SQL_FILE)) {
                return (false);
            }
            $sql = str_replace(array('PREFIX_', 'ENGINE_TYPE'), array(_DB_PREFIX_, _MYSQL_ENGINE_), $sql);
            $sql = preg_split("/;\s*[\r\n]+/", $sql);
            foreach ($sql as $query) {
                if ($query) {
                    if (!Db::getInstance()->execute(trim($query))) {
                        return false;
                    }
                }
            }

            Configuration::updateValue('WK-USPS-ID', '975WEBKU6211');
            Configuration::updateValue('WK-USPS-ORIGIN-ZIPCODE', '10001');
            Configuration::updateValue('WK-USPS-SIZE-DOMESTIC', 'LARGE');
            Configuration::updateValue('WK-USPS-CONTAINER-DOMESTIC', 'RECTANGULAR');
            Configuration::updateValue('WK-USPS-SIZE-INTERNATIONAL', 'REGULAR');
            Configuration::updateValue('WK-USPS-CONTAINER-INTERNATIONAL', 'RECTANGULAR');
            Configuration::updateValue('WK-USPS-MACHINABLE', '1');
            Configuration::updateValue('WK-USPS-HEIGHT', '1');
            Configuration::updateValue('WK-USPS-LENGTH', '1');
            Configuration::updateValue('WK-USPS-WIDTH', '1');
            Configuration::updateValue('WK-USPS-GIRTH', '1');
            Configuration::updateValue('WK-USPS-WEIGHT', '1');
            $obj_usps_services = new USPSShippingServices();
            $usps_shipping_services = $obj_usps_services->getUSPSServices();
            if ($usps_shipping_services) {
                foreach ($usps_shipping_services as $usps_services) {
                    $shipping_services = array(
                        'name' => $usps_services['service_name'],
                        'id_tax_rules_group' => 0,
                        'active' => true,
                        'deleted' => 0,
                        'shipping_handling' => true,
                        'range_behavior' => 0,
                        'delay' => array(Language::getIsoById(Configuration::get('PS_LANG_DEFAULT')) => 'USPS Shipping'),
                        'id_zone' => 1,
                        'is_module' => true,
                        'shipping_external' => true,
                        'external_module_name' => 'wkuspsshipping',
                        'need_range' => true,
                    );
                    $ps_carrier_id = $this->installExternalCarrier($shipping_services);
                    $obj_usps_services->updateIdCarrierById($ps_carrier_id, $usps_services['id']);
                }
            }
            if (!parent::install()
                || !$this->registerHook('updateCarrier')
                ) {
                return false;
            }

            return true;
        } else {
            $this->_errors[] = $this->l('First you need to import USD currency for install this module.');

            return false;
        }
    }

    public static function installExternalCarrier($config)
    {
        $carrier = new Carrier();
        $carrier->name = $config['name'];
        $carrier->id_tax_rules_group = $config['id_tax_rules_group'];
        $carrier->id_zone = $config['id_zone'];
        $carrier->active = $config['active'];
        $carrier->deleted = $config['deleted'];
        $carrier->delay = $config['delay'];
        $carrier->shipping_handling = $config['shipping_handling'];
        $carrier->range_behavior = $config['range_behavior'];
        $carrier->is_module = $config['is_module'];
        $carrier->shipping_external = $config['shipping_external'];
        $carrier->external_module_name = $config['external_module_name'];
        $carrier->need_range = $config['need_range'];

        $languages = Language::getLanguages(true);
        foreach ($languages as $language) {
            if ($language['iso_code'] == Language::getIsoById(Configuration::get('PS_LANG_DEFAULT'))) {
                $carrier->delay[(int) $language['id_lang']] = $config['delay'][$language['iso_code']];
            }
        }

        if ($carrier->add()) {
            $groups = Group::getGroups(true);
            foreach ($groups as $group) {
                Db::getInstance()->autoExecute(_DB_PREFIX_.'carrier_group', array('id_carrier' => (int) ($carrier->id), 'id_group' => (int) ($group['id_group'])), 'INSERT');
            }

            $rangePrice = new RangePrice();
            $rangePrice->id_carrier = $carrier->id;
            $rangePrice->delimiter1 = '0';
            $rangePrice->delimiter2 = '10000';
            $rangePrice->add();

            $rangeWeight = new RangeWeight();
            $rangeWeight->id_carrier = $carrier->id;
            $rangeWeight->delimiter1 = '0';
            $rangeWeight->delimiter2 = '10000';
            $rangeWeight->add();

            $zones = Zone::getZones(true);
            foreach ($zones as $zone) {
                Db::getInstance()->autoExecute(_DB_PREFIX_.'carrier_zone', array('id_carrier' => (int) ($carrier->id), 'id_zone' => (int) ($zone['id_zone'])), 'INSERT');
                Db::getInstance()->autoExecuteWithNullValues(_DB_PREFIX_.'delivery', array('id_carrier' => (int) ($carrier->id), 'id_range_price' => (int) ($rangePrice->id), 'id_range_weight' => null, 'id_zone' => (int) ($zone['id_zone']), 'price' => '0'), 'INSERT');
                Db::getInstance()->autoExecuteWithNullValues(_DB_PREFIX_.'delivery', array('id_carrier' => (int) ($carrier->id), 'id_range_price' => null, 'id_range_weight' => (int) ($rangeWeight->id), 'id_zone' => (int) ($zone['id_zone']), 'price' => '0'), 'INSERT');
            }
            copy(dirname(__FILE__).'/logo.png', _PS_SHIP_IMG_DIR_.'/'.(int) $carrier->id.'.jpg');
            // Return ID Carrier
            return (int) ($carrier->id);
        }

        return false;
    }

    public function getOrderShippingCost($params, $shipping_cost)
    {
        $cost = 0;
        if (Configuration::get('WK-USPS-ID')) {
            $controller = Tools::getValue('controller');
            if (isset($controller)) {
                if ($controller != 'cart' && $controller != 'index' && $controller != 'category' && $controller != 'product') {
                    $products = $params->getProducts();
                    $obj_usps_services = new USPSShippingServices();
                    $usps_carrier_info = $obj_usps_services->getUSPSCarriersByIdCarrier($this->id_carrier);
                    if ($usps_carrier_info) {
                        //Delivery Address details of user
                        $id_address_delivery = $params->id_address_delivery;
                        $objaddress = new Address($id_address_delivery);
                        $destzipcode = $objaddress->postcode;
                        $country_name = $objaddress->country;
                        $id_country = $objaddress->id_country;
                        $objcountry = new Country($id_country);
                        $destcountrycode = $objcountry->getIsoById($id_country);

                        $user_id = Configuration::get('WK-USPS-ID');
                        $originzipcode = Configuration::get('WK-USPS-ORIGIN-ZIPCODE');
                        $machinable = Configuration::get('WK-USPS-MACHINABLE');
                        if ($machinable) {
                            $machinable = 'TRUE';
                        } else {
                            $machinable = 'FALSE';
                        }

                        // Webservices Params
                        $wsParams = array(
                            'id_cart' => $params->id,
                            'id_carrier' => $this->id_carrier,
                            'recipient_postalcode' => $destzipcode,
                            'user_id' => $user_id,
                            'originzipcode' => $originzipcode,
                            'machinable' => $machinable,
                            'country_name' => $country_name,
                            'products' => $products,
                        );
                        $wsParams['hash'] = $this->getOrderShippingCostHash($wsParams);
                        // Check cache
                        $cache = $this->getOrderShippingCostCache($wsParams);
                        if ($cache['id'] > 0) {
                            if ($cache['is_available'] == 0) {
                                return false;
                            }

                            if ($cache['total_charges']) {
                                return $cache['total_charges'];
                            }
                        }

                        if ($products) {
                            $width = 0;
                            $length = 0;
                            $height = 0;
                            $weight = 0;
                            $total_price = 0;
                            foreach ($products as $product) {
                                if ($product['width'] > 0) {
                                    $width += $product['width'];
                                } else {
                                    $width += Configuration::get('WK-USPS-WIDTH');
                                }

                                if ($product['depth'] > 0) {
                                    $length += $product['depth'];
                                } else {
                                    $length += Configuration::get('WK-USPS-LENGTH');
                                }

                                if ($product['height'] > 0) {
                                    $height += $product['height'];
                                } else {
                                    $height += Configuration::get('WK-USPS-HEIGHT');
                                }

                                if ($product['weight'] > 0) {
                                    $weight += ($product['weight'] * $product['quantity']);
                                } else {
                                    $weight += Configuration::get('WK-USPS-WEIGHT');
                                }
                                $total_price += $product['total_wt'];
                            }
                        }
                        if (Configuration::get('PS_WEIGHT_UNIT') == 'kg' || Configuration::get('PS_WEIGHT_UNIT') == 'kgs') {
                            $weight *= 2.2;
                        }
                        if (Configuration::get('PS_DIMENSION_UNIT') == 'cm') {
                            $width *= 0.393701;
                            $length *= 0.393701;
                            $height *= 0.393701;
                        }

                        if ($this->context->currency->iso_code != 'USD') {
                            $conversionRate = $this->getCartCurrencyRate(Currency::getIdByIsoCode('USD'), $this->context->cart->id);
                            $total_price /= $conversionRate; // convert total_price into USD because USPS accept price only in USD
                        }

                        // Get Webservices Cost and Cache it
                        $temp_wsParams = $wsParams;
                        $wsParams['width'] = $width;
                        $wsParams['length'] = $length;
                        $wsParams['height'] = $height;
                        $wsParams['weight'] = $weight;
                        $wsParams['girth'] = Configuration::get('WK-USPS-GIRTH');
                        $wsParams['total_price'] = $total_price;
                        unset($temp_wsParams['hash']);
                        if ($destcountrycode == 'US') {
                            $wsParams['size'] = Configuration::get('WK-USPS-SIZE-DOMESTIC');
                            $wsParams['container'] = Configuration::get('WK-USPS-CONTAINER-DOMESTIC');
                            $carrier_list = $this->uspsDomestic($wsParams);
                        } else {
                            $wsParams['size'] = Configuration::get('WK-USPS-SIZE-INTERNATIONAL');
                            $wsParams['container'] = Configuration::get('WK-USPS-CONTAINER-INTERNATIONAL');
                            $carrier_list = $this->uspsInternationl($wsParams);
                        }

                        $conversionRate = $this->getCartCurrencyRate(Currency::getIdByIsoCode('USD'), $this->context->cart->id);
                        $obj_usps_services = new USPSShippingServices();
                        $all_carrier_list = $obj_usps_services->getUSPSServices();
                        foreach ($all_carrier_list as $carrier) {
                            $carrier_cost = 0;
                            if ($carrier_list) {
                                if (array_key_exists($carrier['class_id'], $carrier_list)) {
                                    $carrier_cost = $carrier_list[$carrier['class_id']];
                                    if ($this->context->currency->iso_code != 'USD') {
                                        $carrier_cost *= $conversionRate; //USPS return shipping cost in USD so you need to convert it into cart currency
                                    }
                                    if (Configuration::get('WK-USPS-HANDLING')) {
                                        $carrier_cost += $shipping_cost; // add prestashop handling fee
                                    }
                                }
                            }
                            $temp_wsParams['id_carrier'] = $carrier['id_carrier'];
                            $wsParams['hash'] = $this->getOrderShippingCostHash($temp_wsParams);
                            $this->saveOrderShippingCostCache($wsParams, $carrier['id_carrier'], $carrier_cost);
                        }
                        if ($carrier_list) {
                            if (array_key_exists($usps_carrier_info['class_id'], $carrier_list)) {
                                $cost = ($carrier_list[$usps_carrier_info['class_id']] * $conversionRate);
                                if (Configuration::get('WK-USPS-HANDLING')) {
                                    $cost += $shipping_cost; // add prestashop handling fee
                                }
                            }
                        }
                    }
                }
            }
        }
        if ($cost) {
            return $cost;
        }

        return false;
    }

    public function getOrderShippingCostHash($wsParams)
    {
        $paramHash = '';
        $productHash = '';
        foreach ($wsParams['products'] as $product) {
            if (!empty($productHash)) {
                $productHash .= '|';
            }
            $productHash .= $product['id_product'].':'.$product['id_product_attribute'].':'.$product['cart_quantity'].':'.$wsParams['user_id'].':'.$wsParams['originzipcode'].':'.$wsParams['recipient_postalcode'].$wsParams['machinable'];
        }
        foreach ($wsParams as $k => $v) {
            if ($k != 'products') {
                $paramHash .= '/'.$v;
            }
        }

        return md5($productHash.$paramHash.'onepackage');
    }

    public function saveOrderShippingCostCache($wsParams, $id_carrier, $wscost)
    {
        $is_available = 1;
        if (!$wscost) {
            $is_available = 0;
        }

        if (!$wscost) {
            $wscost = 0;
        }

        $cart = new Cart((int) $wsParams['id_cart']);

        $obj_mp_correios_cache = new USPSShippingCache();
        $obj_mp_correios_cache->id_cart = (int) ($wsParams['id_cart']);
        $obj_mp_correios_cache->id_carrier = (int) ($id_carrier);
        $obj_mp_correios_cache->hash = pSQL($wsParams['hash']);
        $obj_mp_correios_cache->id_currency = (int) ($cart->id_currency);
        $obj_mp_correios_cache->total_charges = pSQL($wscost);
        $obj_mp_correios_cache->is_available = (int) ($is_available);
        $obj_mp_correios_cache->save();
    }

    public function getOrderShippingCostCache($wsParams)
    {
        // Get Cache
        $obj_usps_cache = new USPSShippingCache();
        $row = $obj_usps_cache->checkCache($wsParams);
        if ($row['id_currency']) {
            // Check Currency Rate And Calculate
            $conversionRate = $this->getCartCurrencyRate($row['id_currency'], (int) $wsParams['id_cart']);
            $row['total_charges'] *= $conversionRate;
            // Return Cache
            return $row;
        }

        return false;
    }

    public function getCartCurrencyRate($id_currency_origin, $id_cart)
    {
        $conversionRate = 1;
        $cart = new Cart($id_cart);
        if ($cart->id_currency != $id_currency_origin) {
            $currencyOrigin = new Currency((int) $id_currency_origin);
            $conversionRate /= $currencyOrigin->conversion_rate;
            $currencySelect = new Currency((int) $cart->id_currency);
            $conversionRate *= $currencySelect->conversion_rate;
        }

        return $conversionRate;
    }

    public function getOrderShippingCostExternal($params)
    {
        return $this->getOrderShippingCost($params, 23);
    }

    public function uspsInternationl($wsParams)
    {
        $wsParams['ounces'] = (($wsParams['weight'] - (int) $wsParams['weight']) * 16);
        $wsParams['weight'] = (int) $wsParams['weight'];
        // =============== DON'T CHANGE BELOW THIS LINE ===============

        $url = 'http://Production.ShippingAPIs.com/ShippingAPI.dll';
        $ch = curl_init();
        // set the target url
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // parameters to post
        curl_setopt($ch, CURLOPT_POST, 1);
        $currentdatetime = date('Y-m-d\TH:i:s', strtotime('+5 hours')); //datetime in ISO8601 format
        $data = 'API=IntlRateV2&XML=<IntlRateV2Request USERID="'.$wsParams['user_id'].'"><Revision>2</Revision><Package ID="0"><Pounds>'.$wsParams['weight'].'</Pounds><Ounces>'.$wsParams['ounces'].'</Ounces><Machinable>'.$wsParams['machinable'].'</Machinable><MailType>All</MailType><ValueOfContents>'.$wsParams['total_price'].'</ValueOfContents><Country>'.$wsParams['country_name'].'</Country><Container>'.$wsParams['container'].'</Container><Size>'.$wsParams['size'].'</Size><Width>'.$wsParams['width'].'</Width><Length>'.$wsParams['length'].'</Length><Height>'.$wsParams['height'].'</Height><Girth>'.$wsParams['girth'].'</Girth><OriginZip>'.$wsParams['originzipcode'].'</OriginZip><CommercialFlag>Y</CommercialFlag><AcceptanceDateTime>'.$currentdatetime.'</AcceptanceDateTime><DestinationPostalCode>'.$wsParams['recipient_postalcode'].'</DestinationPostalCode></Package></IntlRateV2Request>';

        // send the POST values to usps
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        $xml = simplexml_load_string(curl_exec($ch));

        $carrier_list = array();
        if (is_object($xml)) {
            if (is_object($xml->Number) && is_object($xml->Description) && (string) $xml->Description != '') {
                return false;
            } elseif (is_object($xml->Package) && is_object($xml->Package->Error) && is_object($xml->Package->Error->Description) && (string) $xml->Package->Error->Description != '') {
                return false;
            }

            if (is_object($xml->Package) && is_object($xml->Package->Service)) {
                /*foreach ($xml->Package->Service as $postage) {
                    $class_id = (string) $postage->attributes()->ID;
                    $cost = (string) $postage->Postage;
                    $carrier_list['INT_'.$class_id] = $cost;
                }*/

                foreach ($xml->Package->Service as $postage) {
                    $classId = (string) $postage->attributes()->ID;
                    if ($classId == 0) {
                        $serviceName = $this->filterServiceName((string) $postage->MailService);
                        if ($uspsService = USPSShippingServices::getUSPSCarriersByCarrierName($serviceName)) {
                            $classId = $uspsService['class_id'];
                        }
                    }

                    $carrier_list['INT_'.$classId] = (string) $postage->Postage;
                }
            }
        }

        return $carrier_list;
    }

    public function uspsDomestic($wsParams)
    {
        $wsParams['ounces'] = (($wsParams['weight'] - (int) $wsParams['weight']) * 16);
        $wsParams['weight'] = (int) $wsParams['weight'];
        // =============== DON'T CHANGE BELOW THIS LINE ===============
        $url = 'http://Production.ShippingAPIs.com/ShippingAPI.dll';
        $ch = curl_init();
        // set the target url
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // parameters to post
        curl_setopt($ch, CURLOPT_POST, 1);

        $data = 'API=RateV4&XML=<RateV4Request USERID="'.$wsParams['user_id'].'"><Package ID="1ST"><Service>ALL</Service><ZipOrigination>'.$wsParams['originzipcode'].'</ZipOrigination><ZipDestination>'.$wsParams['recipient_postalcode'].'</ZipDestination><Pounds>'.$wsParams['weight'].'</Pounds><Ounces>'.$wsParams['ounces'].'</Ounces><Container>'.$wsParams['container'].'</Container><Size>'.$wsParams['size'].'</Size><Width>'.$wsParams['width'].'</Width><Length>'.$wsParams['length'].'</Length><Height>'.$wsParams['height'].'</Height><Girth>'.$wsParams['girth'].'</Girth><Machinable>'.$wsParams['machinable'].'</Machinable></Package></RateV4Request>';
        // send the POST values to usps
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        $xml = simplexml_load_string(curl_exec($ch));

        $carrier_list = array();
        if (is_object($xml)) {
            if (is_object($xml->Number) && is_object($xml->Description) && (string) $xml->Description != '') {
                return false;
            } elseif (is_object($xml->Package) && is_object($xml->Package->Error) && is_object($xml->Package->Error->Description) && (string) $xml->Package->Error->Description != '') {
                return false;
            }

            if (is_object($xml->Package) && is_object($xml->Package->Postage)) {
                /*foreach ($xml->Package->Postage as $postage) {
                    $class_id = (string) $postage->attributes()->CLASSID;
                    $cost = (string) $postage->Rate;
                    $carrier_list[$class_id] = $cost;
                }*/

                foreach ($xml->Package->Postage as $postage) {
                    $classId = (string) $postage->attributes()->CLASSID;
                    if ($classId == 0) {
                        $serviceName = $this->filterServiceName((string) $postage->MailService);
                        if ($uspsService = USPSShippingServices::getUSPSCarriersByCarrierName($serviceName)) {
                            $classId = $uspsService['class_id'];
                        }
                    }

                    $carrier_list[$classId] = (string) $postage->Rate;
                }
            }
        }

        return $carrier_list;
    }

    public function filterServiceName($serviceName)
    {
        $serviceNameKey = str_replace("&lt;sup&gt;&amp;reg;&lt;/sup&gt;", "", $serviceName);
        $serviceNameKey = str_replace("&lt;sup&gt;&amp;trade;&lt;/sup&gt;", "", $serviceNameKey);
        $serviceNameKey = str_replace("&lt;sup&gt;&#8482;&lt;/sup&gt;", "", $serviceNameKey);
        $serviceNameKey = str_replace("&lt;sup&gt;&#174;&lt;/sup&gt;", "", $serviceNameKey);
        $serviceNameKey = str_replace("l&lt;sup&gt;&#174;&lt;/sup&gt;", "", $serviceNameKey);
        return $serviceNameKey;
    }

    public function dropTable($table_name_without_prefix)
    {
        $drop = Db::getInstance()->execute('DROP TABLE `'._DB_PREFIX_.$table_name_without_prefix.'`');
        if (!$drop) {
            return false;
        }

        return true;
    }

    public function deletePsCarriers()
    {
        $obj_usps_services = new USPSShippingServices();
        $usps_carriers = $obj_usps_services->getUSPSServices();
        if ($usps_carriers) {
            foreach ($usps_carriers as $usps) {
                $carrier = new Carrier((int) ($usps['id_carrier']));
                $carrier->delete();
            }
        }

        return true;
    }

    public function uninstall()
    {
        if (!parent::uninstall()
                || !$this->deletePsCarriers()
                || !$this->dropTable('wk_usps_shipping_services')
                || !$this->dropTable('wk_usps_shipping_cache')
                ) {
            return false;
        }

        return true;
    }
}
