<div class="panel">
	<h3><i class="icon-AdminParentOrders"></i> {l s='Packaging' mod='wkuspsshipping'}</h3>
	<form method="post">
		<div id="usps_my_pack" style="display:block">
			<div class="form-wrapper">
				<div class="form-group row">				
					<div class="col-lg-3 col-md-3 col-xs-3 text-right">{l s='Size(For Domestic Shipping)' mod='wkuspsshipping'} :</div>
					<div class="col-lg-3 col-md-3 col-xs-3 col-offset-lg-6">
						<select name="usps_size_domestic" id="usps_size_domestic">
							<option value="LARGE" {if $USPS_SIZE_DOMESTIC == 'LARGE'}Selected = "Selected"{/if}>{l s='Large' mod='wkuspsshipping'}</option>
							<option value="REGULAR" {if $USPS_SIZE_DOMESTIC == 'REGULAR'}Selected = "Selected"{/if}>{l s='Regular' mod='wkuspsshipping'}</option>
						</select>
					</div>
				</div>
				<div class="form-group row">				
					<div class="col-lg-3 col-md-3 col-xs-3 text-right">{l s='Container(For Domestic Shipping)' mod='wkuspsshipping'} :</div>
					<div class="col-lg-3 col-md-3 col-xs-3 col-offset-lg-6">
						<select name="usps_container_domestic" id="usps_container_domestic">	
							<option value="RECTANGULAR">{l s='Rectangular' mod='wkuspsshipping'}</option>
							<option value="NONRECTANGULAR">{l s='Non Rectangular' mod='wkuspsshipping'}</option>
							<option value="VARIABLE">{l s='Variable' mod='wkuspsshipping'}</option>
						</select>
					</div>
				</div>
				<div class="form-group row">				
					<div class="col-lg-3 col-md-3 col-xs-3 text-right">{l s='Size(For International Shipping)' mod='wkuspsshipping'} :</div>
					<div class="col-lg-3 col-md-3 col-xs-3 col-offset-lg-6">
						<select name="usps_size_international" id="usps_size_international">
							<option value="LARGE" {if $USPS_SIZE_INTERNATIONAL == 'LARGE'}Selected = "Selected"{/if}>{l s='Large' mod='wkuspsshipping'}</option>
							<option value="REGULAR" {if $USPS_SIZE_INTERNATIONAL == 'REGULAR'}Selected = "Selected"{/if}>{l s='Regular' mod='wkuspsshipping'}</option>
						</select>
					</div>
				</div>
				<div class="form-group row">				
					<div class="col-lg-3 col-md-3 col-xs-3 text-right">{l s='Container(For International Shipping)' mod='wkuspsshipping'} :</div>
					<div class="col-lg-3 col-md-3 col-xs-3 col-offset-lg-6">
						<select name="usps_container_international" id="usps_container_international">	
							<option value="RECTANGULAR">{l s='Rectangular' mod='wkuspsshipping'}</option>
							<option value="NONRECTANGULAR">{l s='Non Rectangular' mod='wkuspsshipping'}</option>
							<option value="VARIABLE">{l s='Variable' mod='wkuspsshipping'}</option>
						</select>
					</div>
				</div>
				<div class="form-group row">				
					<div class="col-lg-3 col-md-3 col-xs-3 text-right">{l s='Machinable' mod='wkuspsshipping'} :</div>
					<div class="col-lg-3 col-md-3 col-xs-3 col-offset-lg-6">
						<span class="switch prestashop-switch fixed-width-lg">
							<input type="radio" {if $USPS_MACHINABLE == 1} checked="checked" {/if} value="1" id="usps_machinable_on" name="usps_machinable">
							<label class="radioCheck" for="usps_machinable_on">{l s='Yes' mod='wkuspsshipping'}</label>
							<input type="radio" {if $USPS_MACHINABLE == 0} checked="checked" {/if} value="0" id="usps_machinable_off" name="usps_machinable">
							<label class="radioCheck" for="usps_machinable_off">{l s='No' mod='wkuspsshipping'}</label>
							<a class="slide-button btn"></a>
						</span>
					</div>
				</div>
				<div class="form-group row">				
					<div id="fixed_box" class="col-lg-3 col-md-3 col-xs-3 text-right">{l s='Dimensions' mod='wkuspsshipping'} (in {$dimension_unit|escape:'htmlall':'UTF-8'}):</div>
					<div class="col-lg-3 col-md-3 col-xs-3 col-offset-lg-6">
						<div class="col-lg-3">
							<small>{l s='Width' mod='wkuspsshipping'}</small>
							<br>
							<input name="usps_width" class="needValidate" id="usps_width" value="{$USPS_WIDTH|escape:'htmlall':'UTF-8'}" type="text">
						</div>
						<div class="col-lg-3">
							<small>{l s='Height' mod='wkuspsshipping'}</small>
							<br>
							<input name="usps_height" class="needValidate" id="usps_height" value="{$USPS_HEIGHT|escape:'htmlall':'UTF-8'}" type="text">
						</div>
						<div class="col-lg-3">
							<small>{l s='Length' mod='wkuspsshipping'}</small>
							<br>
							<input name="usps_length" id="usps_length" value="{$USPS_LENGTH|escape:'htmlall':'UTF-8'}" type="text">
						</div>
						<div class="col-lg-3">
							<small>{l s='Girth' mod='wkuspsshipping'}</small>
							<br>
							<input name="usps_girth" id="usps_girth" value="{$USPS_GIRTH|escape:'htmlall':'UTF-8'}" type="text">
						</div>
					</div>
				</div>
				<div class="form-group row">				
					<div id="fixed_box" class="col-lg-3 col-md-3 col-xs-3 text-right">{l s='Weight' mod='wkuspsshipping'} (in {$weight_unit|escape:'htmlall':'UTF-8'}):</div>
					<div class="col-lg-3 col-md-3 col-xs-3 col-offset-lg-6">
						<input name="usps_weight" class="needValidate" id="usps_weight" value="{$USPS_WEIGHT|escape:'htmlall':'UTF-8'}" type="text">
					</div>
				</div>
				<div class="panel-footer">
					<button class="btn btn-default pull-right" name="updateuspsPackaging" value="1" type="submit">
						<i class="process-icon-save"></i> {l s='Save' mod='wkuspsshipping'}
					</button>
				</div>
			</div>			
		</div>
	</form>
</div>
<script>
	$(document).ready(function(){
		var rectangular = "{l s='Rectangular' mod='wkuspsshipping'}";
		var non_rectangular = "{l s='Non Rectangular' mod='wkuspsshipping'}";
		var variable = "{l s='Variable' mod='wkuspsshipping'}";
		var container_d = "{$USPS_CONTAINER_DOMESTIC|escape:'html':'UTF-8'}";
		var container_i = "{$USPS_CONTAINER_INTERNATIONAL|escape:'html':'UTF-8'}";
		function domestic_size(size, is_selected)
		{
			$('#usps_container_domestic').empty();
			if (size == 'REGULAR') {
				$('#usps_container_domestic').append("<option value='VARIABLE'>"+variable+"</option>");
			} else {
				$('#usps_container_domestic').append("<option value='RECTANGULAR'>"+rectangular+"</option>");
				$('#usps_container_domestic').append("<option value='NONRECTANGULAR'>"+non_rectangular+"</option>");
				$('#usps_container_domestic').append("<option value='VARIABLE'>"+variable+"</option>");
				if (is_selected == 1) {
					$("#usps_container_domestic option").filter("[selected='selected']").removeAttr('selected');
					$("#usps_container_domestic option").filter("[value='"+container_d+"']").attr('selected', 'selected');
				}
			}
		}

		function international_size(size, is_selected)
		{
			$('#usps_container_international').empty();
			if (size == 'LARGE') {
				$('#usps_container_international').append("<option value='RECTANGULAR'>"+rectangular+"</option>");
				$('#usps_container_international').append("<option value='NONRECTANGULAR'>"+non_rectangular+"</option>");
			} else {
				$('#usps_container_international').append("<option value='RECTANGULAR'>"+rectangular+"</option>");
				$('#usps_container_international').append("<option value='NONRECTANGULAR'>"+non_rectangular+"</option>");
				$('#usps_container_international').append("<option value='VARIABLE'>"+variable+"</option>");
			}

			if (is_selected == 1) {
				$("#usps_container_international option").filter("[selected='selected']").removeAttr('selected');
				$("#usps_container_international option").filter("[value='"+container_i+"']").attr('selected', 'selected');
			}
		}

		domestic_size($('#usps_size_domestic :selected').val(), 1);
		international_size($('#usps_size_international :selected').val(), 1);
		$(document).on('change', '#usps_size_domestic', function(){
			domestic_size($(this).val(), 0);
		});
		$(document).on('change', '#usps_size_international', function(){
			international_size($(this).val());
		});
	});
</script>