<?php
/**
* Order Approval.
*
* NOTICE OF LICENSE
*
* This product is licensed for one customer to use on one installation (test stores and multishop included).
* Site developer has the right to modify this module to suit their needs, but can not redistribute the module in
* whole or in part. Any other use of this module constitues a violation of the user agreement.
*
* DISCLAIMER
*
* NO WARRANTIES OF DATA SAFETY OR MODULE SECURITY
* ARE EXPRESSED OR IMPLIED. USE THIS MODULE IN ACCORDANCE
* WITH YOUR MERCHANT AGREEMENT, KNOWING THAT VIOLATIONS OF
* PCI COMPLIANCY OR A DATA BREACH CAN COST THOUSANDS OF DOLLARS
* IN FINES AND DAMAGE A STORES REPUTATION. USE AT YOUR OWN RISK.
*
*  @author    idnovate.com <info@idnovate.com>
*  @copyright 2014 idnovate.com
*  @license   See above
*/

class OrderHistory extends OrderHistoryCore
{
	public function changeIdOrderState($new_order_state = null, $id_order)
	{
		if (!Module::isEnabled('orderapproval') || $this->context->cookie->id_employee)
			return parent::changeIdOrderState($new_order_state, $id_order);

		try
		{
			if (!$new_order_state || !$id_order)
				return;

			if (!is_object($id_order) && is_numeric($id_order))
				$order = new Order((int)$id_order);
			elseif (is_object($id_order))
				$order = $id_order;
			else
				return;

			$cart = new Cart((int)$order->id_cart);
			$language = new Language($cart->id_lang);

			//Check if order already have module state
			if (count($order->getHistory($language->id, Configuration::get('ORDERAPP_STATE_ID'))) > 0)
				return parent::changeIdOrderState($new_order_state, $id_order);

			//Get all states marked as validated
			$states = OrderState::getOrderStates($language->id);
			$logable_states = array();
			foreach ($states as $state)
				if ($state['logable'] == 1)
					$logable_states[] = $state['id_order_state'];

			//Get number of products. Take into consideration if we have to consider free products.
			$nb_products = 0;
			if (Configuration::get('ORDERAPP_FREE_PRODUCTS'))
				$nb_products = Cart::getNbProducts((int)$order->id_cart);
			else
			{
				if ($cart->getOrderTotal() > 0)
				{
					$products = $cart->getProducts();
					foreach ($products as $product)
						if ($product['price'] > 0)
							$nb_products += (int)$product['cart_quantity'];
				}
			}

			$validate_per_amount = false;
			if (Configuration::get('ORDERAPP_MINIMUM_AMOUNT_CUR') > 0)
			{
				$currency_to = new Currency(Currency::getIdByIsoCodeNum(Configuration::get('ORDERAPP_MINIMUM_AMOUNT_CUR')));
				$currency_from = new Currency((int)$cart->id_currency);
				$order_amount = Tools::convertPriceFull($cart->getOrderTotal(true, Cart::BOTH), $currency_from, $currency_to);

				if ($order_amount >= Configuration::get('ORDERAPP_MINIMUM_AMOUNT_CUR'))
					$validate_per_amount = true;
			}

			//Check if next status is a validated status.
			//Check if a next state is defined at module.
			//Check if number of products is higher than defined.
			if ((in_array($new_order_state, $logable_states)
				&& (Configuration::get('ORDERAPP_STATE_ID') != '')
				&& (($nb_products) >= Configuration::get('ORDERAPP_LIMIT_PRODUCTS')))
				|| $validate_per_amount)
			{
				try
				{
					parent::changeIdOrderState(Configuration::get('ORDERAPP_STATE_ID'), $id_order);

					Mail::Send(
						$language->id,
						'alert',
						Mail::l('New order pending of validation', $language->id),
						array('{id_order}' => (int)$id_order),
						Configuration::get('PS_SHOP_EMAIL'),
						null, null, null, null, null,
						_PS_MODULE_DIR_.'orderapproval/mails/');
				}
				catch (Exception $e)
				{
					Mail::Send(
						$language->id,
						'error',
						Mail::l('Error creating order', $language->id),
						array('{id_order}' => (int)$id_order),
						Configuration::get('PS_SHOP_EMAIL'),
						null, null, null, null, null,
						_PS_MODULE_DIR_.'orderapproval/mails/');
				}
			}
			else
				parent::changeIdOrderState($new_order_state, $id_order);
		}
		catch (Exception $e)
		{
			parent::changeIdOrderState($new_order_state, $id_order);
		}
	}
}
